<?php
$pageTitle = 'Gestión de Usuarios';
require_once __DIR__ . '/../layouts/header.php';

use Core\Classes\Permission;
Permission::requirePermission('gestionar_usuarios');
?>

<div class="container">
    <div class="page-header">
        <div>
            <h1><i class="fas fa-users"></i> Gestión de Usuarios</h1>
            <p>Administra los usuarios y sus roles en el sistema</p>
        </div>
        <div class="page-header-actions">
            <a href="/usuario/create" class="btn btn-primary">
                <i class="fas fa-user-plus"></i> Nuevo Usuario
            </a>
        </div>
    </div>
    
    <div class="content-card">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>RUT</th>
                    <th>Nombre</th>
                    <th>Email</th>
                    <th>Rol</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($usuarios)): ?>
                    <tr>
                        <td colspan="7">
                            <div class="empty-state">
                                <i class="fas fa-users"></i>
                                <h3>No hay usuarios registrados</h3>
                                <a href="/usuario/create" class="btn btn-primary">
                                    <i class="fas fa-user-plus"></i> Crear Usuario
                                </a>
                            </div>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($usuarios as $usuario): ?>
                        <tr>
                            <td><?= htmlspecialchars($usuario['id']) ?></td>
                            <td><?= htmlspecialchars($usuario['rut']) ?></td>
                            <td><strong><?= htmlspecialchars($usuario['nombres'] . ' ' . $usuario['apellidos']) ?></strong></td>
                            <td><?= htmlspecialchars($usuario['email']) ?></td>
                            <td>
                                <span class="badge" style="background: <?= Permission::getRoleBadgeColor($usuario['rol']) ?>; color: white;">
                                    <?= Permission::getRoleName($usuario['rol']) ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($usuario['estado'] === 'activo'): ?>
                                    <span class="badge badge-success">Activo</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactivo</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions">
                                <a href="/usuario/edit/<?= $usuario['id'] ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if ($usuario['id'] != $_SESSION['user_id']): ?>
                                    <a href="/usuario/delete/<?= $usuario['id'] ?>" 
                                       onclick="return confirm('¿Eliminar este usuario?')" 
                                       class="btn btn-sm btn-danger">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
