<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Nuevo Proveedor</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Nuevo Proveedor</h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/proveedor/store">
        <label for="rut">RUT</label>
        <input type="text" id="rut" name="rut" required />

        <label for="razon_social">Razón Social</label>
        <input type="text" id="razon_social" name="razon_social" required />

        <label for="nombre_comercial">Nombre Comercial</label>
        <input type="text" id="nombre_comercial" name="nombre_comercial" />

        <label for="direccion">Dirección</label>
        <input type="text" id="direccion" name="direccion" />

        <label for="comuna">Comuna</label>
        <input type="text" id="comuna" name="comuna" />

        <label for="region">Región</label>
        <input type="text" id="region" name="region" />

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" />

        <label for="email">Email</label>
        <input type="email" id="email" name="email" />

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" selected>Activo</option>
            <option value="inactivo">Inactivo</option>
        </select>

        <button type="submit">Guardar Proveedor</button>
    </form>

    <a href="/proveedor">Volver al listado</a>
</body>
</html>
