<?php
/**
 * Header Principal del Sistema SG-SSR
 * Incluye sistema de permisos, navegación y estilos globales
 */

// Verificar autenticación (excepto en login)
$current_uri = $_SERVER['REQUEST_URI'];
if (!isset($_SESSION['user_id']) && !in_array($current_uri, ['/login', '/'])) {
    header('Location: /login');
    exit;
}

// Cargar sistema de permisos
require_once __DIR__ . '/../../core/classes/Permission.php';
use Core\Classes\Permission;

// Variables de sesión escapadas
$pageTitle = $pageTitle ?? 'SG-SSR';
$userName = htmlspecialchars($_SESSION['user_name'] ?? 'Usuario', ENT_QUOTES, 'UTF-8');
$userEmail = htmlspecialchars($_SESSION['user_email'] ?? '', ENT_QUOTES, 'UTF-8');
$userRole = $_SESSION['user_role'] ?? '';
$userRoleName = Permission::getRoleName($userRole);
$userRoleColor = Permission::getRoleBadgeColor($userRole);
$empresaNombre = htmlspecialchars($_SESSION['empresa_nombre'] ?? 'Sistema', ENT_QUOTES, 'UTF-8');
$empresaId = $_SESSION['empresa_id'] ?? null;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistema de Gestión para Servicios Sanitarios Rurales">
    <meta name="author" content="SG-SSR">
    <title><?= $pageTitle ?> - SG-SSR</title>
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Estilos Globales -->
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* ========================================
           HEADER DEL SISTEMA
           ======================================== */
        .system-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .system-header .header-content {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .system-header h1 {
            font-size: 1.5rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .system-header h1 i {
            font-size: 1.8rem;
        }
        
        .system-header .company-name {
            font-size: 0.9rem;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .system-header .user-info {
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .system-header .user-badge {
            background: rgba(255,255,255,0.2);
            padding: 10px 20px;
            border-radius: 25px;
            font-size: 0.9rem;
            display: flex;
            flex-direction: column;
            gap: 3px;
            backdrop-filter: blur(10px);
        }
        
        .system-header .user-badge strong {
            font-size: 1rem;
        }
        
        .system-header .role-badge {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            background: <?= $userRoleColor ?>;
            color: white;
        }
        
        .system-header .user-info a {
            color: white;
            text-decoration: none;
            padding: 10px 18px;
            border-radius: 6px;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.95rem;
        }
        
        .system-header .user-info a:hover {
            background: rgba(255,255,255,0.25);
            transform: translateY(-1px);
        }
        
        .system-header .user-info a i {
            font-size: 1.1rem;
        }
        
        /* ========================================
           BREADCRUMBS
           ======================================== */
        .breadcrumbs {
            background: white;
            padding: 12px 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            flex-wrap: wrap;
            gap: 8px;
        }
        
        .breadcrumbs a {
            color: #667eea;
            text-decoration: none;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .breadcrumbs a:hover {
            color: #5568d3;
            text-decoration: underline;
        }
        
        .breadcrumbs span {
            color: #999;
        }
        
        .breadcrumbs strong {
            color: #495057;
        }
        
        /* ========================================
           PAGE HEADER
           ======================================== */
        .page-header {
            background: white;
            padding: 30px;
            margin-bottom: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .page-header h1 {
            color: #2c3e50;
            font-size: 2rem;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .page-header h1 i {
            color: #667eea;
        }
        
        .page-header p {
            color: #7f8c8d;
            font-size: 1rem;
            margin: 5px 0 0 0;
        }
        
        .page-header-actions {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        /* ========================================
           CONTENT CARD
           ======================================== */
        .content-card {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }
        
        .content-card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .content-card-header h2 {
            color: #2c3e50;
            font-size: 1.5rem;
            margin: 0;
        }
        
        /* ========================================
           BOTONES
           ======================================== */
        .btn {
            display: inline-block;
            padding: 10px 20px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 0.95rem;
            text-align: center;
        }
        
        .btn i {
            margin-right: 5px;
        }
        
        .btn-primary {
            background: #667eea;
            color: white;
        }
        
        .btn-primary:hover {
            background: #5568d3;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(102,126,234,0.4);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn-success:hover {
            background: #218838;
        }
        
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        
        .btn-danger:hover {
            background: #c82333;
        }
        
        .btn-warning {
            background: #ffc107;
            color: #333;
        }
        
        .btn-warning:hover {
            background: #e0a800;
        }
        
        .btn-info {
            background: #17a2b8;
            color: white;
        }
        
        .btn-info:hover {
            background: #138496;
        }
        
        .btn-sm {
            padding: 6px 12px;
            font-size: 0.85rem;
        }
        
        .btn-lg {
            padding: 12px 28px;
            font-size: 1.1rem;
        }
        
        /* ========================================
           TABLAS
           ======================================== */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background: white;
        }
        
        table thead {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        table th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        table td {
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
            vertical-align: middle;
        }
        
        table tbody tr {
            transition: background 0.2s;
        }
        
        table tbody tr:hover {
            background: #f8f9fa;
        }
        
        table tbody tr:last-child td {
            border-bottom: none;
        }
        
        /* ========================================
           FORMULARIOS
           ======================================== */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #495057;
            font-weight: 500;
            font-size: 0.95rem;
        }
        
        .form-group label.required::after {
            content: " *";
            color: #dc3545;
        }
        
        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            font-size: 1rem;
            transition: all 0.3s;
            font-family: inherit;
        }
        
        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102,126,234,0.1);
        }
        
        .form-group textarea {
            min-height: 100px;
            resize: vertical;
        }
        
        .form-group small {
            display: block;
            margin-top: 5px;
            color: #6c757d;
            font-size: 0.85rem;
        }
        
        /* ========================================
           ALERTAS
           ======================================== */
        .alert {
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 6px;
            border-left: 4px solid;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .alert i {
            font-size: 1.3rem;
        }
        
        .alert-success {
            background: #d4edda;
            border-color: #28a745;
            color: #155724;
        }
        
        .alert-danger {
            background: #f8d7da;
            border-color: #dc3545;
            color: #721c24;
        }
        
        .alert-warning {
            background: #fff3cd;
            border-color: #ffc107;
            color: #856404;
        }
        
        .alert-info {
            background: #d1ecf1;
            border-color: #17a2b8;
            color: #0c5460;
        }
        
        /* ========================================
           EMPTY STATE
           ======================================== */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #6c757d;
        }
        
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 20px;
            color: #dee2e6;
        }
        
        .empty-state h3 {
            margin-bottom: 10px;
            color: #495057;
            font-size: 1.3rem;
        }
        
        .empty-state p {
            margin-bottom: 20px;
            font-size: 1rem;
        }
        
        /* ========================================
           ACTIONS
           ======================================== */
        .actions {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }
        
        /* ========================================
           BADGES
           ======================================== */
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .badge-success {
            background: #d4edda;
            color: #155724;
        }
        
        .badge-danger {
            background: #f8d7da;
            color: #721c24;
        }
        
        .badge-warning {
            background: #fff3cd;
            color: #856404;
        }
        
        .badge-info {
            background: #d1ecf1;
            color: #0c5460;
        }
        
        .badge-secondary {
            background: #e9ecef;
            color: #495057;
        }
        
        /* ========================================
           RESPONSIVE
           ======================================== */
        @media (max-width: 768px) {
            .system-header .header-content {
                flex-direction: column;
                text-align: center;
            }
            
            .container {
                padding: 10px;
            }
            
            .page-header {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .page-header h1 {
                font-size: 1.5rem;
            }
            
            table {
                font-size: 0.85rem;
            }
            
            table th, table td {
                padding: 10px;
            }
            
            .btn {
                width: 100%;
            }
            
            .actions {
                width: 100%;
            }
            
            .actions a, .actions button {
                flex: 1;
            }
        }
    </style>
</head>
<body>
    <!-- Header del Sistema -->
    <div class="system-header">
        <div class="header-content">
            <div>
                <h1>
                    <i class="fas fa-water"></i> 
                    SG-SSR
                    <?php if ($userRole !== 'superadmin' && $empresaNombre !== 'Sistema'): ?>
                        <span class="company-name"> - <?= $empresaNombre ?></span>
                    <?php endif; ?>
                </h1>
            </div>
            <div class="user-info">
                <div class="user-badge">
                    <strong><i class="fas fa-user-circle"></i> <?= $userName ?></strong>
                    <span class="role-badge"><?= $userRoleName ?></span>
                </div>
                <a href="/dashboard" title="Ir al Dashboard">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a href="/logout" title="Cerrar Sesión">
                    <i class="fas fa-sign-out-alt"></i> Salir
                </a>
            </div>
        </div>
    </div>
