<?php
$pageTitle = 'Gestión de Empresas';
require_once __DIR__ . '/../layouts/header.php';

use Core\Classes\Permission;
Permission::requirePermission('crear_empresas');
?>

<div class="container">
    <div class="page-header">
        <div>
            <h1><i class="fas fa-building"></i> Gestión de Empresas</h1>
            <p>Administra las empresas (SSR) del sistema</p>
        </div>
        <div class="page-header-actions">
            <a href="/empresa/create" class="btn btn-primary">
                <i class="fas fa-plus"></i> Nueva Empresa
            </a>
        </div>
    </div>
    
    <div class="content-card">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>RUT</th>
                    <th>RAZÓN SOCIAL</th>
                    <th>NOMBRE COMERCIAL</th>
                    <th>ESTADO</th>
                    <th>ACCIONES</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($empresas)): ?>
                    <tr>
                        <td colspan="6">
                            <div class="empty-state">
                                <i class="fas fa-building"></i>
                                <h3>No hay empresas registradas</h3>
                                <a href="/empresa/create" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Crear Empresa
                                </a>
                            </div>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($empresas as $empresa): ?>
                        <tr>
                            <td><?= htmlspecialchars($empresa['id'] ?? '') ?></td>
                            <td><?= htmlspecialchars($empresa['rut'] ?? '-') ?></td>
                            <td><strong><?= htmlspecialchars($empresa['razon_social'] ?? $empresa['nombre'] ?? 'Sin nombre') ?></strong></td>
                            <td><?= htmlspecialchars($empresa['nombre_comercial'] ?? $empresa['nombre'] ?? '-') ?></td>
                            <td>
                                <?php 
                                $estado = $empresa['estado'] ?? 'activo';
                                if ($estado === 'activo' || $estado === '1' || $estado === 1): 
                                ?>
                                    <span class="badge badge-success">Activo</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactivo</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions">
                                <a href="/empresa/edit/<?= $empresa['id'] ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="/empresa/delete/<?= $empresa['id'] ?>" 
                                   onclick="return confirm('¿Eliminar esta empresa?')" 
                                   class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
