<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Documentos</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Documentos</h1>
    <a href="/documento/create">Nuevo Documento</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Descripción</th>
                <th>Tipo</th>
                <th>Fecha Subida</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($documentos as $doc): ?>
            <tr>
                <td><?= htmlspecialchars($doc['id']) ?></td>
                <td><?= htmlspecialchars($doc['nombre']) ?></td>
                <td><?= htmlspecialchars($doc['descripcion']) ?></td>
                <td><?= htmlspecialchars($doc['tipo']) ?></td>
                <td><?= htmlspecialchars($doc['fecha_subida']) ?></td>
                <td>
                    <a href="/documento/edit/<?= $doc['id'] ?>">Editar</a> |
                    <a href="/documento/delete/<?= $doc['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
