<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Documento</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Documento #<?= htmlspecialchars($documento['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/documento/update/<?= $documento['id'] ?>">
        <label for="nombre">Nombre</label>
        <input type="text" id="nombre" name="nombre" value="<?= htmlspecialchars($documento['nombre']) ?>" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion"><?= htmlspecialchars($documento['descripcion']) ?></textarea>

        <label for="tipo">Tipo</label>
        <input type="text" id="tipo" name="tipo" value="<?= htmlspecialchars($documento['tipo']) ?>" />

        <label for="archivo">Archivo (ruta o nombre)</label>
        <input type="text" id="archivo" name="archivo" value="<?= htmlspecialchars($documento['archivo']) ?>" />

        <button type="submit">Actualizar Documento</button>
    </form>

    <a href="/documento">Volver al listado</a>
</body>
</html>
