<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Nuevo Caso Contactabilidad</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Crear Nuevo Caso</h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/contactabilidad/store">
        <label for="tipo">Tipo</label>
        <select id="tipo" name="tipo" required>
            <option value="reclamo">Reclamo</option>
            <option value="consulta">Consulta</option>
            <option value="sugerencia">Sugerencia</option>
            <option value="felicitacion">Felicitación</option>
            <option value="contacto">Contacto</option>
        </select>

        <label for="asunto">Asunto</label>
        <input type="text" id="asunto" name="asunto" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion" rows="5" required></textarea>

        <button type="submit">Crear Caso</button>
    </form>

    <a href="/contactabilidad">Volver al listado</a>
</body>
</html>
