<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Nuevo Cliente</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Nuevo Cliente</h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/cliente/store">
        <label for="rut">RUT</label>
        <input type="text" id="rut" name="rut" required />

        <label for="nombres">Nombres</label>
        <input type="text" id="nombres" name="nombres" required />

        <label for="apellidos">Apellidos</label>
        <input type="text" id="apellidos" name="apellidos" required />

        <label for="correo">Correo</label>
        <input type="email" id="correo" name="correo" />

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" />

        <label for="direccion">Dirección</label>
        <input type="text" id="direccion" name="direccion" />

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" selected>Activo</option>
            <option value="inactivo">Inactivo</option>
        </select>

        <button type="submit">Guardar Cliente</button>
    </form>

    <a href="/cliente">Volver al listado</a>
</body>
</html>
