<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Nueva Categoría</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Nueva Categoría</h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/categoria/store">
        <label for="nombre">Nombre</label>
        <input type="text" id="nombre" name="nombre" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion"></textarea>

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" selected>Activo</option>
            <option value="inactivo">Inactivo</option>
        </select>

        <button type="submit">Guardar Categoría</button>
    </form>

    <a href="/categoria">Volver al listado</a>
</body>
</html>
