<?php
$pageTitle = 'Gestión de Bancos';
require_once __DIR__ . '/../layouts/header.php';

use Core\Classes\Permission;
Permission::requirePermission('gestionar_bancos');
?>

<div class="container">
    <div class="page-header">
        <div>
            <h1><i class="fas fa-university"></i> Gestión de Bancos</h1>
            <p>Administra las instituciones bancarias del sistema</p>
        </div>
        <div class="page-header-actions">
            <a href="/banco/create" class="btn btn-primary">
                <i class="fas fa-plus"></i> Nuevo Banco
            </a>
        </div>
    </div>
    
    <div class="content-card">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Código</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($bancos)): ?>
                    <tr>
                        <td colspan="5">
                            <div class="empty-state">
                                <i class="fas fa-university"></i>
                                <h3>No hay bancos registrados</h3>
                                <a href="/banco/create" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Crear Banco
                                </a>
                            </div>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($bancos as $banco): ?>
                        <tr>
                            <td><?= htmlspecialchars($banco['id']) ?></td>
                            <td><strong><?= htmlspecialchars($banco['nombre']) ?></strong></td>
                            <td><?= htmlspecialchars($banco['codigo'] ?? '-') ?></td>
                            <td>
                                <?php if ($banco['estado'] === 'activo'): ?>
                                    <span class="badge badge-success">Activo</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactivo</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions">
                                <a href="/banco/edit/<?= $banco['id'] ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="/banco/delete/<?= $banco['id'] ?>" 
                                   onclick="return confirm('¿Eliminar este banco?')" 
                                   class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
