<?php
namespace Core\Models;

use Core\Classes\Database;

class Proveedor {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM proveedores WHERE empresa_id = ? AND deleted_at IS NULL ORDER BY razon_social ASC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM proveedores WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO proveedores (empresa_id, rut, razon_social, nombre_comercial, direccion, comuna, region, telefono, email, estado, fecha_registro) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())');
        return $stmt->execute([
            $data['empresa_id'],
            $data['rut'],
            $data['razon_social'],
            $data['nombre_comercial'] ?? '',
            $data['direccion'] ?? '',
            $data['comuna'] ?? '',
            $data['region'] ?? '',
            $data['telefono'] ?? '',
            $data['email'] ?? '',
            $data['estado'] ?? 'activo'
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE proveedores SET rut = ?, razon_social = ?, nombre_comercial = ?, direccion = ?, comuna = ?, region = ?, telefono = ?, email = ?, estado = ? WHERE id = ?');
        return $stmt->execute([
            $data['rut'],
            $data['razon_social'],
            $data['nombre_comercial'] ?? '',
            $data['direccion'] ?? '',
            $data['comuna'] ?? '',
            $data['region'] ?? '',
            $data['telefono'] ?? '',
            $data['email'] ?? '',
            $data['estado'] ?? 'activo',
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE proveedores SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
