<?php
namespace Core\Models;

use Core\Classes\Database;

class ContactabilidadAdjunto {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getByCaso($caso_id) {
        $stmt = $this->db->prepare('SELECT * FROM contactabilidad_adjuntos WHERE caso_id = ? ORDER BY fecha_subida DESC');
        $stmt->execute([$caso_id]);
        return $stmt->fetchAll();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO contactabilidad_adjuntos (caso_id, archivo, tipo_archivo, fecha_subida) VALUES (?, ?, ?, NOW())');
        return $stmt->execute([
            $data['caso_id'],
            $data['archivo'],
            $data['tipo_archivo']
        ]);
    }
}
