<?php
namespace Core\Models;

use Core\Classes\Database;

class Banco {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll() {
        $stmt = $this->db->query('SELECT * FROM banco ORDER BY nombre ASC');
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM banco WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO banco (id, nombre, descripcion, pais, cod_sii, codigo, estado, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())');
        return $stmt->execute([
            $data['id'],
            $data['nombre'],
            $data['descripcion'] ?? '',
            $data['pais'] ?? 'Chile',
            $data['cod_sii'] ?? '',
            $data['codigo'] ?? '',
            $data['estado'] ?? 'activo'
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE banco SET nombre = ?, descripcion = ?, pais = ?, cod_sii = ?, codigo = ?, estado = ?, updated_at = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['nombre'],
            $data['descripcion'],
            $data['pais'],
            $data['cod_sii'],
            $data['codigo'],
            $data['estado'],
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM banco WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
