<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Reporte;

class ReporteController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Reporte();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        // Ejemplo: casos por estado
        $casosPorEstado = $this->model->getCasosPorEstado($empresa_id);
        require __DIR__ . '/../../views/reporte/index.php';
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
