<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Proveedor;

class ProveedorController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Proveedor();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $proveedores = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/proveedor/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/proveedor/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'rut' => $_POST['rut'],
            'razon_social' => $_POST['razon_social'],
            'nombre_comercial' => $_POST['nombre_comercial'] ?? '',
            'direccion' => $_POST['direccion'] ?? '',
            'comuna' => $_POST['comuna'] ?? '',
            'region' => $_POST['region'] ?? '',
            'telefono' => $_POST['telefono'] ?? '',
            'email' => $_POST['email'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->create($data)) {
            header('Location: /proveedor');
            exit;
        }
        $error = 'Error al crear proveedor';
        require __DIR__ . '/../../views/proveedor/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $proveedor = $this->model->getById($id);
        if (!$proveedor) {
            header('Location: /proveedor');
            exit;
        }
        require __DIR__ . '/../../views/proveedor/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'rut' => $_POST['rut'],
            'razon_social' => $_POST['razon_social'],
            'nombre_comercial' => $_POST['nombre_comercial'] ?? '',
            'direccion' => $_POST['direccion'] ?? '',
            'comuna' => $_POST['comuna'] ?? '',
            'region' => $_POST['region'] ?? '',
            'telefono' => $_POST['telefono'] ?? '',
            'email' => $_POST['email'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /proveedor');
            exit;
        }
        $error = 'Error al actualizar proveedor';
        $proveedor = $this->model->getById($id);
        require __DIR__ . '/../../views/proveedor/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /proveedor');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
