<?php
namespace Core\Controllers;

use Core\Models\ProveedorContacto;

class ProveedorContactoController {
    private $model;

    public function __construct() {
        $this->model = new ProveedorContacto();
    }

    public function list($proveedor_id) {
        $contactos = $this->model->getAllByProveedor($proveedor_id);
        include __DIR__ . '/../../views/proveedor_contactos/list.php';
    }

    public function createForm($proveedor_id) {
        include __DIR__ . '/../../views/proveedor_contactos/create.php';
    }

    public function create($data) {
        $this->model->create($data);
        header('Location: /proveedores/contactos/list/' . $data['proveedorid']);
        exit;
    }

    public function editForm($id) {
        $contacto = $this->model->getById($id);
        include __DIR__ . '/../../views/proveedor_contactos/edit.php';
    }

    public function update($id, $data) {
        $this->model->update($id, $data);
        header('Location: /proveedores/contactos/list/' . $data['proveedorid']);
        exit;
    }

    public function delete($id) {
        $contacto = $this->model->getById($id);
        $this->model->delete($id);
        header('Location: /proveedores/contactos/list/' . $contacto['proveedorid']);
        exit;
    }
}
