<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Classes\Mail;

class NotificacionController {
    private $auth;
    private $mail;

    public function __construct() {
        $this->auth = new Auth();
        $this->mail = new Mail();
    }

    public function enviarNotificacion($email, $mensaje) {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
        $subject = "Notificación SSR";
        return $this->mail->sendMail($email, $subject, $mensaje);
    }
}
