<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Documento;

class DocumentoController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Documento();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $documentos = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/documento/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/documento/create.php';
    }

    public function store() {
        $this->checkAuth();
        // Para simplificar, asumiendo que el archivo ya fue subido y path se recibe desde POST
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'nombre' => $_POST['nombre'],
            'descripcion' => $_POST['descripcion'] ?? '',
            'tipo' => $_POST['tipo'] ?? '',
            'archivo' => $_POST['archivo'] ?? '',
            'creado_por' => $_SESSION['user_id']
        ];
        if ($this->model->create($data)) {
            header('Location: /documento');
            exit;
        }
        $error = 'Error al crear documento';
        require __DIR__ . '/../../views/documento/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $documento = $this->model->getById($id);
        if (!$documento) {
            header('Location: /documento');
            exit;
        }
        require __DIR__ . '/../../views/documento/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'nombre' => $_POST['nombre'],
            'descripcion' => $_POST['descripcion'] ?? '',
            'tipo' => $_POST['tipo'] ?? '',
            'archivo' => $_POST['archivo'] ?? '',
            'actualizado_por' => $_SESSION['user_id']
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /documento');
            exit;
        }
        $error = 'Error al actualizar documento';
        $documento = $this->model->getById($id);
        require __DIR__ . '/../../views/documento/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /documento');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
