<?php
session_start(); // Asegúrate de iniciar sesión siempre
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'superadmin') {
    // Si no eres superadmin, redirige o muestra error
    header('Location: /dashboard'); // O una página de acceso denegado
    exit;
}

// ...el resto del código (require controlador, render vista, etc)

require_once 'EmpresaModuloController.php';
$controller = new EmpresaModuloController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    $empresa_id = intval($_POST['empresa_id']);
    $modulo_id = intval($_POST['modulo_id']);
    $habilitado = intval($_POST['habilitado']);
    $controller->setModuloEmpresa($empresa_id, $modulo_id, $habilitado);
    echo "ok";
    exit;
}

$data = $controller->getAllEmpresasModulos();
$empresas = [];
foreach ($data as $row) {
    $empresas[$row['empresa_id']]['nombre'] = $row['empresa'];
    $empresas[$row['empresa_id']]['modulos'][] = $row;
}
?>
<html>
<head>
    <title>Gestión de Módulos por Empresa</title>
    <script>
        function cambiarModulo(empresa_id, modulo_id, habilitado) {
            var xhttp = new XMLHttpRequest();
            xhttp.open("POST", "", true);
            xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhttp.onreadystatechange = function() {
                if (xhttp.readyState == 4 && xhttp.status == 200) {
                    // Opcional: mostrar mensaje o refrescar parte de la página
                }
            };
            xhttp.send("ajax=1&empresa_id=" + empresa_id + "&modulo_id=" + modulo_id + "&habilitado=" + (habilitado ? "1" : "0"));
        }
    </script>
</head>
<body>
<h2>Activar/Desactivar módulos por empresa</h2>
<?php foreach ($empresas as $eid => $empresa): ?>
    <h3><?php echo htmlspecialchars($empresa['nombre']); ?></h3>
    <table border="1">
        <tr>
            <th>Módulo</th>
            <th>Habilitado</th>
        </tr>
        <?php foreach ($empresa['modulos'] as $modulo): ?>
        <tr>
            <td><?php echo htmlspecialchars($modulo['modulo']); ?></td>
            <td>
                <input type="checkbox"
                    <?php echo $modulo['habilitado'] ? "checked" : ""; ?>
                    onclick="cambiarModulo(<?php echo $eid; ?>, <?php echo $modulo['modulo_id']; ?>, this.checked)">
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
<?php endforeach; ?>
</body>
</html>
