<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Casos de Contactabilidad</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Casos de Contactabilidad</h1>
    <a href="/contactabilidad/create">Nuevo Caso</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Tipo</th>
                <th>Estado</th>
                <th>Asunto</th>
                <th>Fecha Creación</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($casos as $caso): ?>
            <tr>
                <td><?= htmlspecialchars($caso['id']) ?></td>
                <td><?= htmlspecialchars($caso['tipo']) ?></td>
                <td><?= htmlspecialchars($caso['estado']) ?></td>
                <td><?= htmlspecialchars($caso['asunto']) ?></td>
                <td><?= htmlspecialchars($caso['fecha_creacion']) ?></td>
                <td>
                    <a href="/contactabilidad/edit/<?= $caso['id'] ?>">Editar</a> |
                    <a href="/contactabilidad/delete/<?= $caso['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
