<?php
namespace Core\Models;

use Core\Classes\Database;

class PortalCliente {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function crearReclamo($data) {
        $stmt = $this->db->prepare('INSERT INTO casos (empresa_id, cliente_id, tipo, estado, asunto, descripcion, fecha_creacion, creado_por) VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)');
        return $stmt->execute([
            $data['empresa_id'],
            $data['cliente_id'],
            'reclamo',
            'pendiente',
            $data['asunto'],
            $data['descripcion'],
            $data['cliente_id']
        ]);
    }

    public function obtenerReclamosPorCliente($cliente_id) {
        $stmt = $this->db->prepare('SELECT * FROM casos WHERE cliente_id = ? ORDER BY fecha_creacion DESC');
        $stmt->execute([$cliente_id]);
        return $stmt->fetchAll();
    }
}
