<?php
namespace Core\Models;

use Core\Classes\Database;

class ContactabilidadCliente {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM contactabilidad_clientes WHERE empresa_id = ? AND estado = "activo"');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM contactabilidad_clientes WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO contactabilidad_clientes (empresa_id, rut, nombres, apellidos, email, telefono, estado, fecha_registro) VALUES (?, ?, ?, ?, ?, ?, "activo", NOW())');
        return $stmt->execute([
            $data['empresa_id'],
            $data['rut'],
            $data['nombres'],
            $data['apellidos'],
            $data['email'],
            $data['telefono']
        ]);
    }
}
