<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Seguimiento;

class SeguimientoController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Seguimiento();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $seguimientos = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/seguimiento/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/seguimiento/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'entidad' => $_POST['entidad'],
            'entidad_id' => $_POST['entidad_id'],
            'descripcion' => $_POST['descripcion'],
            'estado' => $_POST['estado'] ?? 'pendiente',
            'fecha_seguimiento' => $_POST['fecha_seguimiento'],
            'creado_por' => $_SESSION['user_id']
        ];
        if ($this->model->create($data)) {
            header('Location: /seguimiento');
            exit;
        }
        $error = 'Error al crear seguimiento';
        require __DIR__ . '/../../views/seguimiento/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $seguimiento = $this->model->getById($id);
        if (!$seguimiento) {
            header('Location: /seguimiento');
            exit;
        }
        require __DIR__ . '/../../views/seguimiento/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'descripcion' => $_POST['descripcion'],
            'estado' => $_POST['estado'] ?? 'pendiente',
            'fecha_seguimiento' => $_POST['fecha_seguimiento'],
            'actualizado_por' => $_SESSION['user_id']
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /seguimiento');
            exit;
        }
        $error = 'Error al actualizar seguimiento';
        $seguimiento = $this->model->getById($id);
        require __DIR__ . '/../../views/seguimiento/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /seguimiento');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
