<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Nuevo Movimiento</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Nuevo Movimiento de Tesorería</h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/tesoreria/store">
        <label for="tipo">Tipo</label>
        <input type="text" id="tipo" name="tipo" required />

        <label for="monto">Monto</label>
        <input type="number" step="0.01" id="monto" name="monto" required />

        <label for="cuenta">Cuenta</label>
        <input type="text" id="cuenta" name="cuenta" />

        <label for="fecha_movimiento">Fecha Movimiento</label>
        <input type="date" id="fecha_movimiento" name="fecha_movimiento" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion"></textarea>

        <button type="submit">Guardar Movimiento</button>
    </form>

    <a href="/tesoreria">Volver al listado</a>
</body>
</html>
