<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Proveedores</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Proveedores</h1>
    <a href="/proveedor/create">Nuevo Proveedor</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>RUT</th>
                <th>Razón Social</th>
                <th>Nombre Comercial</th>
                <th>Teléfono</th>
                <th>Email</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($proveedores as $p): ?>
            <tr>
                <td><?= htmlspecialchars($p['id']) ?></td>
                <td><?= htmlspecialchars($p['rut']) ?></td>
                <td><?= htmlspecialchars($p['razon_social']) ?></td>
                <td><?= htmlspecialchars($p['nombre_comercial']) ?></td>
                <td><?= htmlspecialchars($p['telefono']) ?></td>
                <td><?= htmlspecialchars($p['email']) ?></td>
                <td><?= htmlspecialchars($p['estado']) ?></td>
                <td>
                    <a href="/proveedor/edit/<?= $p['id'] ?>">Editar</a> |
                    <a href="/proveedor/delete/<?= $p['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
