<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Listado de Empresas</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Listado de Empresas</h1>
    <a href="/empresa/create">Crear Nueva Empresa</a>
    <table border="1" cellspacing="0" cellpadding="5">
        <thead>
            <tr>
                <th>ID</th>
                <th>Rut</th>
                <th>Razón Social</th>
                <th>Nombre Comercial</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($empresas as $empresa): ?>
            <tr>
                <td><?= htmlspecialchars($empresa['id']) ?></td>
                <td><?= htmlspecialchars($empresa['rut']) ?></td>
                <td><?= htmlspecialchars($empresa['razon_social']) ?></td>
                <td><?= htmlspecialchars($empresa['nombre_comercial']) ?></td>
                <td><?= htmlspecialchars($empresa['estado']) ?></td>
                <td>
                    <a href="/empresa/edit/<?= $empresa['id'] ?>">Editar</a> |
                    <a href="/empresa/delete/<?= $empresa['id'] ?>" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
