<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard SSR</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
        }
        .header {
            background: #667eea;
            color: white;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .welcome-box {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-top: 20px;
        }
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        .info-item {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #667eea;
        }
        .info-label {
            font-weight: bold;
            color: #666;
            font-size: 12px;
            text-transform: uppercase;
        }
        .info-value {
            font-size: 18px;
            color: #333;
            margin-top: 5px;
        }
        .logout-btn {
            display: inline-block;
            padding: 10px 20px;
            background: #e74c3c;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .logout-btn:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1>Sistema de Gestión SSR</h1>
        </div>
    </div>
    
    <div class="container">
        <div class="welcome-box">
            <h2>Bienvenido, <?= htmlspecialchars($_SESSION['user_name']) ?></h2>
            
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Email</div>
                    <div class="info-value"><?= htmlspecialchars($_SESSION['user_email']) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Rol</div>
                    <div class="info-value"><?= htmlspecialchars($_SESSION['user_role']) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">ID Usuario</div>
                    <div class="info-value"><?= htmlspecialchars($_SESSION['user_id']) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">ID Empresa</div>
                    <div class="info-value"><?= htmlspecialchars($_SESSION['empresa_id']) ?></div>
                </div>
            </div>
            
            <a href="/logout" class="logout-btn">Cerrar Sesión</a>
        </div>
    </div>
</body>
</html>
