<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Definir rutas base
define('BASE_PATH', __DIR__);
define('VIEWS_PATH', __DIR__ . '/views');

// Cargar archivos base
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/core/classes/Database.php';
require_once __DIR__ . '/core/classes/Auth.php';
require_once __DIR__ . '/core/classes/Session.php';
require_once __DIR__ . '/core/classes/Router.php';

// Autoload
spl_autoload_register(function ($class) {
    $prefix = 'Core\\';
    $base_dir = __DIR__ . '/core/';
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) return;
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    if (file_exists($file)) require $file;
});

// Iniciar sesión
\Core\Classes\Session::start();

$router = new \Core\Classes\Router();

// ============================================
// RUTAS
// ============================================

// Ruta raíz
$router->add('GET', '/', function () {
    header('Location: /login');
    exit;
});

// GET /login - Mostrar formulario
$router->add('GET', '/login', function() {
    if (isset($_SESSION['user_id'])) {
        header('Location: /dashboard');
        exit;
    }
    require BASE_PATH . '/views/auth/login.php';
});

// POST /login - Procesar login
$router->add('POST', '/login', function() {
    $email = $_POST['email'] ?? null;
    $password = $_POST['password'] ?? null;

    if (!$email || !$password) {
        $error = 'Por favor ingrese email y contraseña';
        require BASE_PATH . '/views/auth/login.php';
        return;
    }

    try {
        $db = \Core\Classes\Database::getInstance()->getConnection();
        $stmt = $db->prepare("SELECT * FROM usuarios WHERE email = ? AND estado = 'activo'");
        $stmt->execute([$email]);
        $user = $stmt->fetch(\PDO::FETCH_ASSOC);
        
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['empresa_id'] = $user['empresa_id'];
            $_SESSION['user_role'] = $user['rol'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_name'] = $user['nombres'] . ' ' . $user['apellidos'];
            
            header('Location: /dashboard');
            exit;
        } else {
            $error = 'Credenciales inválidas';
        }
    } catch (\Exception $e) {
        $error = 'Error del sistema: ' . $e->getMessage();
    }
    
    require BASE_PATH . '/views/auth/login.php';
});

// Logout
$router->add('GET', '/logout', function() {
    session_unset();
    session_destroy();
    header('Location: /login');
    exit;
});

// Dashboard
$router->add('GET', '/dashboard', function () {
    if (!isset($_SESSION['user_id'])) {
        header('Location: /login');
        exit;
    }
    require BASE_PATH . '/views/dashboard/index.php';
});

// Dispatch
$method = $_SERVER['REQUEST_METHOD'];
$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$router->dispatch($method, $path);
