<?php
namespace Core\Controllers;

use Core\Classes\Database;

class EmpresaController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    // Listar todas las empresas activas
    public function index() {
        $stmt = $this->db->query('SELECT * FROM core_empresas WHERE deleted_at IS NULL');
        $empresas = $stmt->fetchAll();
        require __DIR__ . '/../../views/empresa/index.php';
    }

    // Mostrar formulario para crear nueva empresa
    public function create() {
        require __DIR__ . '/../../views/empresa/create.php';
    }

    // Guardar nueva empresa
    public function store($data) {
        $stmt = $this->db->prepare('INSERT INTO core_empresas (rut, razon_social, nombre_comercial, direccion, comuna, region, telefono, email, web, estado, fecha_activacion, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())');
        return $stmt->execute([
            $data['rut'],
            $data['razon_social'],
            $data['nombre_comercial'],
            $data['direccion'],
            $data['comuna'],
            $data['region'],
            $data['telefono'],
            $data['email'],
            $data['web'],
            $data['estado'] ?? 'activo',
            $data['fecha_activacion']
        ]);
    }

    // Mostrar formulario para editar empresa
    public function edit($id) {
        $stmt = $this->db->prepare('SELECT * FROM core_empresas WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        $empresa = $stmt->fetch();
        require __DIR__ . '/../../views/empresa/edit.php';
    }

    // Actualizar empresa
    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE core_empresas SET rut = ?, razon_social = ?, nombre_comercial = ?, direccion = ?, comuna = ?, region = ?, telefono = ?, email = ?, web = ?, estado = ?, fecha_activacion = ?, updated_at = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['rut'],
            $data['razon_social'],
            $data['nombre_comercial'],
            $data['direccion'],
            $data['comuna'],
            $data['region'],
            $data['telefono'],
            $data['email'],
            $data['web'],
            $data['estado'],
            $data['fecha_activacion'],
            $id
        ]);
    }

    // Eliminar empresa (borrado lógico)
    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE core_empresas SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
