<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Cliente;

class ClienteController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Cliente();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $clientes = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/cliente/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/cliente/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'rut' => $_POST['rut'],
            'nombres' => $_POST['nombres'],
            'apellidos' => $_POST['apellidos'],
            'correo' => $_POST['correo'] ?? '',
            'telefono' => $_POST['telefono'] ?? '',
            'direccion' => $_POST['direccion'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->create($data)) {
            header('Location: /cliente');
            exit;
        }
        $error = 'Error al crear cliente';
        require __DIR__ . '/../../views/cliente/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $cliente = $this->model->getById($id);
        if (!$cliente) {
            header('Location: /cliente');
            exit;
        }
        require __DIR__ . '/../../views/cliente/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'rut' => $_POST['rut'],
            'nombres' => $_POST['nombres'],
            'apellidos' => $_POST['apellidos'],
            'correo' => $_POST['correo'] ?? '',
            'telefono' => $_POST['telefono'] ?? '',
            'direccion' => $_POST['direccion'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo',
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /cliente');
            exit;
        }
        $error = 'Error al actualizar cliente';
        $cliente = $this->model->getById($id);
        require __DIR__ . '/../../views/cliente/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /cliente');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
