<?php

namespace Core\Classes;

class Router {
    private $routes = [];

    public function add($method, $path, $handler) {
        $this->routes[] = ['method' => strtoupper($method), 'path' => $path, 'handler' => $handler];
    }

    public function dispatch($method, $path) {
        foreach ($this->routes as $route) {
            if ($route['method'] === strtoupper($method) && preg_match('#^' . $route['path'] . '$#', $path, $params)) {
                array_shift($params); // Remove the full match
                if (is_callable($route['handler'])) {
                    return call_user_func_array($route['handler'], $params);
                } elseif (is_string($route['handler'])) {
                    // Handler format: Controller@method
                    list($controller, $method) = explode('@', $route['handler']);
                    $controller = '\\Core\\Controllers\\' . $controller;
                    if (class_exists($controller)) {
                        $controllerInstance = new $controller();
                        if (method_exists($controllerInstance, $method)) {
                            return call_user_func_array([$controllerInstance, $method], $params);
                        }
                    }
                }
                return null;
            }
        }
        http_response_code(404);
        echo 'Página no encontrada.';
        exit;
    }
}
