<?php
namespace Core\Classes;

class Auth {
    /**
     * Verifica si hay un usuario autenticado
     */
    public function check() {
        return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
    }

    /**
     * Obtiene el ID del usuario autenticado
     */
    public function id() {
        return $_SESSION['user_id'] ?? null;
    }

    /**
     * Obtiene el email del usuario autenticado
     */
    public function email() {
        return $_SESSION['user_email'] ?? null;
    }

    /**
     * Obtiene el nombre completo del usuario autenticado
     */
    public function name() {
        return $_SESSION['user_name'] ?? null;
    }

    /**
     * Obtiene el rol del usuario autenticado
     */
    public function role() {
        return $_SESSION['user_role'] ?? null;
    }

    /**
     * Obtiene el ID de la empresa del usuario autenticado
     */
    public function empresaId() {
        return $_SESSION['empresa_id'] ?? null;
    }

    /**
     * Verifica si el usuario tiene un rol específico
     */
    public function hasRole($role) {
        return $this->role() === $role;
    }

    /**
     * Verifica si el usuario es administrador
     */
    public function isAdmin() {
        return $this->hasRole('admin');
    }

    /**
     * Verifica si el usuario es operador
     */
    public function isOperador() {
        return $this->hasRole('operador');
    }

    /**
     * Verifica si el usuario es cliente
     */
    public function isCliente() {
        return $this->hasRole('cliente');
    }

    /**
     * Cierra la sesión del usuario
     */
    public function logout() {
        session_unset();
        session_destroy();
    }

    /**
     * Obtiene todos los datos del usuario en sesión
     */
    public function user() {
        if (!$this->check()) {
            return null;
        }

        return [
            'id' => $this->id(),
            'email' => $this->email(),
            'name' => $this->name(),
            'role' => $this->role(),
            'empresa_id' => $this->empresaId()
        ];
    }
}
