<?php
session_start();
$config = include __DIR__ . '/config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$user = $_SESSION['user'] ?? null;
if (!$user || $user['rol'] > 2) { header('Location: index.php'); exit; }

$stmt = $pdo->query("SELECT rut, nombre_completo, email, activador FROM socios WHERE activador IS NOT NULL AND activador != '' ORDER BY rut");
$activadores = $stmt->fetchAll();
//$activadores = []; // Define la variable para que la página cargue vacía
?>
<!DOCTYPE html>
<html>
<head>
    <title>🔍 Códigos Activador</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body{font-family:'Segoe UI',Arial,sans-serif;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;padding:30px;}
        .container{max-width:1000px;margin:0 auto;}
        .header{background:linear-gradient(135deg,#77216F,#5E2750);color:white;padding:40px;border-radius:20px;text-align:center;}
        .table-container{background:white;padding:30px;border-radius:20px;margin:30px 0;box-shadow:0 15px 40px rgba(0,0,0,0.1);overflow-x:auto;}
        table{width:100%;border-collapse:collapse;}
        th,td{padding:15px;text-align:left;border-bottom:1px solid #eee;}
        th{background:#f8f9fa;color:#333;font-weight:600;}
        .activador{font-family:monospace;background:#e9ecef;padding:8px;border-radius:5px;font-size:14px;}
        .back-link{display:inline-block;background:#6c757d;color:white;padding:12px 25px;border-radius:10px;text-decoration:none;}
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-search"></i> Códigos Activador</h1>
            <p>Todos los activadores generados (<?= count($activadores) ?>)</p>
        </div>

        <div class="table-container">
            <?php if($activadores): ?>
            <table>
                <thead>
                    <tr>
                        <th>RUT</th>
                        <th>Nombre</th>
                        <th>Email</th>
                        <th>Activador Completo</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($activadores as $a): ?>
                    <tr>
                        <td><strong><?= htmlspecialchars($a['rut']) ?></strong></td>
                        <td><?= htmlspecialchars($a['nombre_completo']) ?></td>
                        <td><?= htmlspecialchars($a['email']) ?></td>
                        <td><span class="activador"><?= htmlspecialchars($a['activador']) ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <p style="text-align:center;padding:40px;color:#666;">No hay activadores generados</p>
            <?php endif; ?>

            <div style="text-align:center;margin-top:30px;">
                <a href="activacion.php" style="background:#ffc107;color:#212529;padding:15px 30px;border-radius:10px;font-weight:600;text-decoration:none;">⚡ Generar Nuevo</a>
                <a href="index.php?p=dashboard" class="back-link">← Dashboard</a>
            </div>
        </div>
    </div>
</body>
</html>
