<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'config.php';
require_once 'rut.php';

function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }
function user() { return $_SESSION['user'] ?? null; }

$user = user();
// Control de Acceso: Solo Superadmin (1) y Admin SSR (2)
if (!$user || $user['rol'] > 2) {
    header('Location: index.php');
    exit;
}

$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$success = $error = '';
$rendicion_id = (int)($_GET['id'] ?? 0);


// ===============================================
// 1. CARGAR Y VALIDAR RENDICIÓN PARA EL FORMULARIO
// ===============================================

$rendicion = null;
if ($rendicion_id > 0) {
    $stmt = $pdo->prepare("SELECT r.*, s.nombre as ssr_nombre 
                           FROM rendiciones r 
                           JOIN ssr s ON r.ssr_id = s.id 
                           WHERE r.id = ?");
    $stmt->execute([$rendicion_id]);
    $rendicion = $stmt->fetch();

    if (!$rendicion) {
        $error = "❌ Rendición ID #{$rendicion_id} no encontrada.";
    } 
    // CONTROL DE ACCESO CRÍTICO: Rol 2 solo ve rendiciones de su SSR
    elseif ($user['rol'] == 2 && $rendicion['ssr_id'] != $user['ssr_id']) {
        $error = "❌ No tiene permisos para modificar esta rendición.";
        $rendicion = null; // Bloquear la visualización y el formulario
    }
}


// ===============================================
// 2. PROCESAMIENTO POST (Subir PDF)
// ===============================================

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rendicion_id_post = (int)$_POST['rendicion_id'];
    $campo_pdf = trim($_POST['campo_pdf'] ?? '');

    // Re-validar existencia y permisos en el POST
    $stmt_post = $pdo->prepare("SELECT ssr_id FROM rendiciones WHERE id = ?");
    $stmt_post->execute([$rendicion_id_post]);
    $rendicion_post = $stmt_post->fetch();
    
    if (!$rendicion_post) {
        $error = "❌ Rendición para actualización no encontrada.";
    } 
    elseif ($user['rol'] == 2 && $rendicion_post['ssr_id'] != $user['ssr_id']) {
        $error = "❌ No tiene permisos para actualizar esta rendición.";
    } 
    elseif (!in_array($campo_pdf, ['pdf1', 'pdf2', 'pdf3'])) {
        $error = "❌ Campo de PDF no válido.";
    }
    elseif (!isset($_FILES['pdf']) || $_FILES['pdf']['error'] !== UPLOAD_ERR_OK) {
        $error = "❌ Error en el archivo subido.";
    } 
    else {
        $file = $_FILES['pdf'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

        // Validaciones del archivo
        if ($ext !== 'pdf' || $file['size'] > 5 * 1024 * 1024) { // Max 5MB
            $error = "❌ El archivo debe ser PDF y menor a 5MB.";
        }
        
        if (!$error) {
            $ssr_id_for_name = $rendicion_post['ssr_id']; // Usamos el ID de la BD, no el del usuario
            $new_name = 'rend_' . $ssr_id_for_name . '_' . $campo_pdf . '_' . time() . '.' . $ext;
            $upload_dir = 'uploads/';

            if (move_uploaded_file($file['tmp_name'], $upload_dir . $new_name)) {
                // Actualizar la base de datos
                $sql = "UPDATE rendiciones SET {$campo_pdf} = ? WHERE id = ?";
                $pdo->prepare($sql)->execute([$new_name, $rendicion_id_post]);
                
                $success = "✅ PDF subido/reemplazado exitosamente en el campo '{$campo_pdf}'.";
                
                // Recargar los datos de la rendición para actualizar la vista
                header("Location: subir_pdf.php?id={$rendicion_id_post}&msg=success");
                exit;

            } else {
                $error = "❌ No se pudo mover el archivo al directorio de subidas.";
            }
        }
    }
}

// Manejar el mensaje de redirección
if (isset($_GET['msg']) && $_GET['msg'] === 'success') {
    $success = "✅ PDF subido/reemplazado exitosamente.";
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>📤 Subir / Reemplazar PDF</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #77216F;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
        }
        body{font-family:'Segoe UI',Arial,sans-serif;background:#f8f9fa;padding:30px;min-height:100vh;}
        .container{max-width:800px;margin:0 auto;}
        .header{background:linear-gradient(135deg,var(--primary),#5E2750);color:white;padding:30px;border-radius:15px;text-align:center;margin-bottom:30px;}
        .form-container{background:white;padding:40px;border-radius:15px;box-shadow:0 10px 30px rgba(0,0,0,0.1);}
        .form-group{margin-bottom:20px;}
        label{display:block;margin-bottom:8px;color:#333;font-weight:600;}
        .form-input, input[type="file"], select{padding:12px;border:1px solid #ddd;border-radius:8px;width:100%;font-size:16px;font-family:inherit;}
        .btn{padding:12px 25px;border-radius:8px;font-weight:600;cursor:pointer;transition:all 0.3s;text-decoration:none;display:inline-block;border:none;}
        .btn-success{background:var(--success);color:white;}
        .btn-success:hover{background:#218838;}
        .btn-back{background:#6c757d;color:white;}
        .btn-back:hover{background:#5a6268;}
        .alert-error{background:#f8d7da;color:var(--danger);padding:15px;border-radius:8px;margin-bottom:20px;border-left:5px solid var(--danger);}
        .alert-success{background:#d4edda;color:var(--success);padding:15px;border-radius:8px;margin-bottom:20px;border-left:5px solid var(--success);}
        .pdf-list h4 { color: var(--primary); margin-top: 30px; margin-bottom: 15px; }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h1><i class="fas fa-file-upload"></i> Subir / Reemplazar PDF</h1>
        <p>Usuario: **<?= e($user['nombre_completo']) ?>** (<?= $user['rol'] == 1 ? 'Superadmin' : 'Admin SSR' ?>)</p>
    </div>

    <?php if ($error): ?><div class="alert-error"><?= $error ?></div><?php endif; ?>
    <?php if ($success): ?><div class="alert-success"><?= $success ?></div><?php endif; ?>

    <?php if ($rendicion): ?>
    <div class="form-container">
        <h2>📑 Rendición: **<?= e($rendicion['titulo']) ?>**</h2>
        <p style="color:#666;margin-bottom:30px;">SSR: **<?= e($rendicion['ssr_nombre']) ?>** | ID: #<?= $rendicion['id'] ?></p>

        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="rendicion_id" value="<?= $rendicion['id'] ?>">

            <div class="form-group">
                <label>Seleccionar Archivo PDF * (Máx. 5MB)</label>
                <input type="file" name="pdf" required accept=".pdf">
            </div>

            <div class="form-group">
                <label>Campo a Reemplazar / Subir</label>
                <select name="campo_pdf" required class="form-input">
                    <option value="pdf1" <?= $rendicion['pdf1'] ? '' : 'selected' ?>>PDF Principal (pdf1)</option>
                    <option value="pdf2" <?= $rendicion['pdf2'] ? '' : 'selected' ?>>PDF Anexo 1 (pdf2)</option>
                    <option value="pdf3" <?= $rendicion['pdf3'] ? '' : 'selected' ?>>PDF Anexo 2 (pdf3)</option>
                </select>
            </div>
            
            <div style="margin-top:20px; text-align: right;">
                <a href="rendiciones_admin.php" class="btn btn-back"><i class="fas fa-arrow-left"></i> Volver</a>
                <button type="submit" class="btn btn-success">🚀 Subir / Reemplazar PDF</button>
            </div>
        </form>

        <div class="pdf-list">
            <h4>📋 PDFs Actuales:</h4>
            <?php 
            $pdfs = ['pdf1' => $rendicion['pdf1'], 'pdf2' => $rendicion['pdf2'], 'pdf3' => $rendicion['pdf3']];
            foreach($pdfs as $campo => $archivo): 
                if($archivo): 
            ?>
            <div style="margin:10px 0;padding:10px;background:#fff;border-radius:6px;border-left:4px solid var(--success);">
                <strong><?= ucfirst(str_replace('pdf', 'PDF', $campo)) ?>:</strong> 
                <a href="uploads/<?= e($archivo) ?>" target="_blank"><?= e($archivo) ?></a>
            </div>
            <?php endif; endforeach; ?>
            <?php if(!array_filter($pdfs)): ?>
            <p style="color:#999;">📭 Sin PDFs subidos</p>
            <?php endif; ?>
        </div>
    </div>
    <?php else: ?>
    <div class="form-container" style="text-align:center;padding:60px;">
        <h3>⚠️ No se puede acceder a esta rendición.</h3>
        <p style="color:var(--danger);"><?= e($error) ?></p>
        <a href="rendiciones_admin.php" class="btn btn-back" style="margin-top:20px;"><i class="fas fa-arrow-left"></i> Volver a la Lista</a>
    </div>
    <?php endif; ?>
</div>
</body>
</html>