<?php
// ==========================================
// ✅ PÚBLICO 100% - SIN SESSION - EN RAÍZ
// Filtro de Seguridad: Solo muestra rendiciones con estado='publicada'
// ==========================================
$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$ssr_id = (int)($_GET['ssr'] ?? 1);
$stmt = $pdo->prepare("SELECT * FROM ssr WHERE id = ?");
$stmt->execute([$ssr_id]);
$ssr = $stmt->fetch();

// CORRECCIÓN: Filtrar por estado='publicada' y ordenar por fecha de finalización descendente
$stmt = $pdo->prepare("
    SELECT * FROM rendiciones 
    WHERE ssr_id = ? AND estado = 'publicada' 
    ORDER BY periodo_fin DESC, id DESC 
    LIMIT 10
");
$stmt->execute([$ssr_id]);
$rendiciones = $stmt->fetchAll();

// Función helper para HTML
function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title><?= e($ssr['nombre'] ?? 'SSR') ?> - Rendiciones Públicas</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #77216F;
            --secondary: #5E2750;
            --success: #28a745;
            --notice: #E95420; /* Nuevo color para el aviso */
        }
        *{margin:0;padding:0;box-sizing:border-box;}
        body{font-family:'Segoe UI',Arial,sans-serif;background:#f8f9fa;min-height:100vh;}
        .header{background:linear-gradient(135deg,var(--primary),var(--secondary));color:white;padding:40px;text-align:center;}
        .container{max-width:1000px;margin:0 auto;padding:30px;}
        .card{background:white;padding:30px;border-radius:15px;margin-bottom:30px;box-shadow:0 10px 30px rgba(0,0,0,0.1);}
        
        /* Estilo para la tarjeta de Aviso (Novedad) */
        .notice-card{border-left:5px solid var(--notice);}
        .rend-item-notice a{background:var(--success);color:white;padding:8px 15px;border-radius:6px;text-decoration:none;font-weight:600;display:inline-block;margin-top:15px;transition: background 0.3s;}
        .rend-item-notice a:hover{background:#218838;}

        .rend-item{padding:20px;margin-bottom:15px;background:#fafbfc;border-left:5px solid var(--primary);border-radius:10px;display:flex;justify-content:space-between;align-items:center;}
        .rend-item-details{flex-grow:1;}
        .rend-item-actions a{color:var(--primary);margin-left:15px;text-decoration:none;font-weight:600;}
        .rend-item-actions a:hover{text-decoration:underline;}
        .rend-item h4{margin-bottom:5px;color:var(--secondary);}
        .no-data{text-align:center;padding:60px;color:#666;}
    </style>
</head>
<body>
    <div class="header">
        <h1><i class="fas fa-file-invoice-dollar"></i> <?= e($ssr['nombre'] ?? 'SSR') ?></h1>
        <p>Rendiciones Públicas SSR</p>
    </div>

    <div class="container">
        <?php if($ssr): ?>
            
            <?php if(!empty($rendiciones)): 
                $ultima = $rendiciones[0]; // La primera es la más reciente por el ORDER BY
            ?>
            <div class="card notice-card">
                <h2 style="color:var(--notice);margin-bottom:15px;"><i class="fas fa-bullhorn"></i> ¡Última Publicación!</h2>
                <div class="rend-item-notice">
                    <h4 style="color:var(--secondary);"><?= e($ultima['titulo']) ?></h4>
                    <p style="color:#666;font-style:italic;">Período: <?= date('M/Y', strtotime($ultima['periodo_inicio'])) ?> - <?= date('M/Y', strtotime($ultima['periodo_fin'])) ?></p>
                    <p style="margin-top: 10px;"><?= nl2br(e(substr($ultima['contenido'], 0, 200) . (strlen($ultima['contenido']) > 200 ? '...' : ''))) ?></p>
                    <?php if($ultima['pdf1']): ?>
                        <a href="uploads/<?= e($ultima['pdf1']) ?>" target="_blank"><i class="fas fa-file-pdf"></i> Ver PDF Principal</a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card">
                <h3 style="color:var(--primary);margin-bottom:20px;">📋 Historial de Rendiciones (<?= count($rendiciones) ?>)</h3>
                
                <?php foreach($rendiciones as $r): ?>
                <div class="rend-item">
                    <div class="rend-item-details">
                        <h4><?= e($r['titulo']) ?></h4>
                        <p style="color:#666;font-size:0.9em;">
                            <?= e($r['tipo_periodo']) ?> (<?= date('M/Y', strtotime($r['periodo_inicio'])) ?> - <?= date('M/Y', strtotime($r['periodo_fin'])) ?>)
                        </p>
                    </div>
                    <div class="rend-item-actions">
                        <?php if($r['pdf1']): ?>
                            <a href="uploads/<?= e($r['pdf1']) ?>" target="_blank" title="Ver PDF Principal"><i class="fas fa-file-pdf"></i> PDF</a>
                        <?php endif; ?>
                        <?php if($r['pdf2']): ?>
                            <a href="uploads/<?= e($r['pdf2']) ?>" target="_blank" title="Ver Anexo 1"><i class="fas fa-paperclip"></i> Anexo 1</a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
        <?php else: ?>
            <div class="card">
                <h2 style="color:var(--primary);margin-bottom:15px;"><?= e($ssr['nombre']) ?></h2>
                <?php if($ssr['descripcion']): ?><p><?= e($ssr['descripcion']) ?></p><?php endif; ?>
            </div>
            <div class="no-data">
                <i class="fas fa-eye-slash" style="font-size:4em;color:#ddd;"></i>
                <h3>No hay rendiciones publicadas</h3>
                <p>La SSR no ha publicado rendiciones de cuentas aún.</p>
            </div>
        <?php endif; ?>
        
        <?php else: ?>
            <div class="no-data">
                <i class="fas fa-exclamation-triangle" style="font-size:4em;color:var(--danger);"></i>
                <h3>SSR ID <?= $ssr_id ?> no encontrada</h3>
            </div>
        <?php endif; ?>

        <div style="text-align:center;margin-top:30px;">
            <a href="index.php" style="background:var(--primary);color:white;padding:15px 30px;border-radius:10px;text-decoration:none;font-weight:600;">🔐 Panel Administradores</a>
        </div>
    </div>
</body>
</html>