<?php
// ==========================================
// ✅ PÚBLICO TOTAL - SIN LOGIN - SIN SESSION
// Para: https://rendiciones.comite-ssr.cl/rendiciones.php?ssr=1
// ==========================================
$config = include '../config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$ssr_id = (int)($_GET['ssr'] ?? 1);
$stmt = $pdo->prepare("SELECT * FROM ssr WHERE id = ?");
$stmt->execute([$ssr_id]);
$ssr = $stmt->fetch();

$stmt = $pdo->prepare("SELECT * FROM rendiciones WHERE ssr_id = ? ORDER BY fecha DESC LIMIT 10");
$stmt->execute([$ssr_id]);
$rendiciones = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($ssr['nombre'] ?? 'SSR') ?> - Rendiciones</title>
    <meta charset="utf-8">
    <style>
        body{font-family:Arial,sans-serif;background:#f5f5f5;margin:0;padding:20px;}
        .container{max-width:900px;margin:0 auto;background:white;border-radius:10px;box-shadow:0 5px 20px rgba(0,0,0,0.1);overflow:hidden;}
        .header{background:#77216F;color:white;padding:30px;text-align:center;}
        .content{padding:30px;}
        .ssr-info{margin-bottom:30px;padding:20px;background:#f8f9fa;border-radius:8px;}
        .rend-item{padding:20px;margin-bottom:15px;background:#fafbfc;border-left:4px solid #77216F;}
        .no-data{text-align:center;padding:50px;color:#666;}
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?= htmlspecialchars($ssr['nombre'] ?? 'SSR') ?></h1>
            <p>Rendiciones Públicas</p>
        </div>
        
        <div class="content">
            <?php if($ssr): ?>
                <div class="ssr-info">
                    <h2><?= htmlspecialchars($ssr['nombre']) ?></h2>
                    <p><?= htmlspecialchars($ssr['descripcion'] ?? '') ?></p>
                </div>
                
                <?php if($rendiciones): ?>
                    <?php foreach($rendiciones as $r): ?>
                    <div class="rend-item">
                        <h3><?= htmlspecialchars($r['titulo']) ?></h3>
                        <p style="color:#666;"><?= date('d/m/Y', strtotime($r['fecha'])) ?></p>
                        <p><?= nl2br(htmlspecialchars($r['contenido'])) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="no-data">
                        <h3>No hay rendiciones publicadas</h3>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="no-data">SSR no encontrada</div>
            <?php endif; ?>
            
            <div style="text-align:center;margin-top:30px;padding:20px;background:#f8f9fa;">
                <a href="../index.php" style="color:#77216F;font-weight:bold;">🔐 Panel Administradores</a>
            </div>
        </div>
    </div>
</body>
</html>
