<?php
session_start();
$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

// 1. DEFINICIONES
$roles = [1 => 'Superadmin', 2 => 'admin_local', 3 => 'directivo', 4 => 'usuario', 5 => 'socio'];
$msg = '';
$edit = null;

// 2. VERIFICACIÓN DE ACCESO
$user = $_SESSION['user'] ?? null;
if (!$user || $user['rol'] > 2) {
    header('Location: index.php');
    exit;
}

// 3. OBTENER DATOS PARA FORMULARIOS
// Obtener SSRs activos (para el SELECT)
$stmt = $pdo->query("SELECT id, nombre FROM ssr WHERE activo = 1 ORDER BY nombre");
$ssrs = $stmt->fetchAll();

// 4. LÓGICA CRUD (Manejo de POST)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    $rut = trim($_POST['rut']);
    $nombre_completo = trim($_POST['nombre_completo']);
    $email = trim($_POST['email']);
    $rol = (int)$_POST['rol'];
    $ssr_id = (int)$_POST['ssr_id'];
    $password = $_POST['password'] ?? '';
    $activo = isset($_POST['activo']) ? 1 : 0;

    // --- A) CREACIÓN DE NUEVO USUARIO (ID es 0 o vacío) ---
    if ($id === 0) {
        if (empty($rut) || empty($password)) {
            $msg = "<div style='color:red;'>❌ RUT y Contraseña son obligatorios para crear un usuario.</div>";
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO socios (rut, nombre_completo, email, rol, ssr_id, password_hash, activo) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$rut, $nombre_completo, $email, $rol, $ssr_id, $hash, $activo]);
            $msg = "<div style='color:green;'>✅ Usuario creado con éxito.</div>";
            // Limpia el POST y redirige para evitar duplicados
            header('Location: admin_socios.php?msg=' . urlencode($msg));
            exit;
        }
    } 
    // --- B) ACTUALIZACIÓN DE USUARIO EXISTENTE (ID > 0) ---
    else {
        $update_fields = [
            'rut' => $rut,
            'nombre_completo' => $nombre_completo,
            'email' => $email,
            'rol' => $rol,
            'ssr_id' => $ssr_id,
            'activo' => $activo,
            'id' => $id
        ];
        
        $sql = "UPDATE socios SET rut = :rut, nombre_completo = :nombre_completo, email = :email, rol = :rol, ssr_id = :ssr_id, activo = :activo";
        
        // Si se envió una nueva contraseña, actualízala
        if (!empty($password)) {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $sql .= ", password_hash = :hash";
            $update_fields['hash'] = $hash;
        }
        
        $sql .= " WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute($update_fields);
        $msg = "<div style='color:green;'>✅ Socio actualizado con éxito.</div>";
    }
}

// 5. LÓGICA DE EDICIÓN Y ELIMINACIÓN (Manejo de GET)
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM socios WHERE id = ?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
} elseif (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    // Borrado lógico (se recomienda no borrar, solo desactivar)
    $stmt = $pdo->prepare("UPDATE socios SET activo = 0 WHERE id = ?"); 
    $stmt->execute([$id]);
    $msg = "<div style='color:orange;'>⚠️ Socio ID $id ha sido desactivado (Borrado Lógico).</div>";
    header('Location: admin_socios.php?msg=' . urlencode($msg));
    exit;
} elseif (isset($_GET['msg'])) {
    // Muestra mensajes después de una redirección
    $msg = urldecode($_GET['msg']);
}


// 6. LÓGICA DE LISTADO (Búsqueda y Paginación)
$search = trim($_GET['search'] ?? '');
$where = '1=1';
$params = [];

if (!empty($search)) {
    $where = " (s.rut LIKE ? OR s.nombre_completo LIKE ? OR s.email LIKE ?)";
    $search_param = "%$search%";
    $params = [$search_param, $search_param, $search_param];
}

$stmt = $pdo->prepare("
    SELECT s.*, r.nombre as ssr_nombre 
    FROM socios s
    LEFT JOIN ssr r ON s.ssr_id = r.id
    WHERE {$where}
    ORDER BY s.id DESC
    LIMIT 200
");
$stmt->execute($params);
$socios = $stmt->fetchAll();

// Fin del bloque PHP
?>
<!DOCTYPE html>
<html>
<head>
    <title>👥 Admin Socios SSR</title>
    </head>
<body>
<div class="container">
    <div class="header">
        <h1><i class="fas fa-users-cog"></i> Administración Socios SSR</h1>
        <p>Gestión completa de usuarios y roles</p>
    </div>

    <?php if(!empty($msg)): ?>
        <div style="padding: 15px; margin: 20px 0; border-radius: 8px; font-weight: 600;"><?= $msg ?></div>
    <?php endif; ?>

    <div class="form-container">
        <h2 class="form-title"><?= $edit ? '✏️ Editar Socio' : '➕ Nuevo Socio' ?></h2>
        
        <form method="POST">
            <input type="hidden" name="id" value="<?= $edit['id'] ?? '' ?>">
            
            <div class="form-group">
                <label class="form-label">🆔 RUT</label>
                <input class="form-input" name="rut" value="<?= htmlspecialchars($edit['rut'] ?? '') ?>" required>
            </div>
            <div class="form-group">
                <label class="form-label">👤 Nombre Completo</label>
                <input class="form-input" name="nombre_completo" value="<?= htmlspecialchars($edit['nombre_completo'] ?? '') ?>" required>
            </div>
            <div class="form-group">
                <label class="form-label">📧 Email</label>
                <input class="form-input" name="email" value="<?= htmlspecialchars($edit['email'] ?? '') ?>" type="email">
            </div>
            
            <div class="form-group">
                <label class="form-label">🏢 SSR *</label>
                <select class="form-select" name="ssr_id" required>
                    <option value="">-- Seleccione SSR --</option>
                    <?php foreach($ssrs as $ssr): ?>
                        <option value="<?= $ssr['id'] ?>" <?= (($edit['ssr_id'] ?? 1) == $ssr['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($ssr['nombre']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label class="form-label">🎭 Rol *</label>
                <select class="form-select" name="rol" required>
                    <?php foreach($roles as $k => $v): ?>
                        <option value="<?= $k ?>" <?= (($edit['rol'] ?? 5) == $k) ? 'selected' : '' ?>><?= $v ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label class="form-label">🔒 Contraseña <?= $edit ? '(Dejar vacío para no cambiar)' : '*' ?></label>
                <input class="form-input" name="password" type="password" <?= $edit ? '' : 'required' ?>>
            </div>
            
            <div class="form-group" style="display:flex;align-items:center;">
                <input type="checkbox" name="activo" <?= (!isset($edit['activo']) || $edit['activo']) ? 'checked' : '' ?> style="width:20px;height:20px;margin-right:10px;">
                <label class="form-label" style="margin:0;">✅ Activo</label>
            </div>
            
            <button type="submit" class="btn btn-primary"><?= $edit ? '💾 Actualizar Socio' : '➕ Crear Socio' ?></button>
            <?php if($edit): ?>
                <a href="admin_socios.php" class="btn">❌ Cancelar Edición</a>
            <?php endif; ?>
        </form>
    </div>

    </div>
</body>
</html>