<?php
// AÑADIR ESTO:
ini_set('display_errors', 1);
error_reporting(E_ALL);
// FIN DE AÑADIR
// ... el resto del código ...
session_start();
$config = include __DIR__ . '/config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$user = $_SESSION['user'] ?? null;
if (!$user || $user['rol'] > 2) { header('Location: index.php'); exit; }

$msg = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rut = trim($_POST['rut']);
    $numero_cliente = trim($_POST['numero_cliente']);
    $boleta1 = trim($_POST['boleta1']);
    $boleta2 = trim($_POST['boleta2']);
    $boleta3 = trim($_POST['boleta3']);
    
    $activador = "$rut+$numero_cliente+$boleta1+$boleta2+$boleta3";
    $hash = password_hash($activador, PASSWORD_DEFAULT);
    
    $pdo->prepare("UPDATE socios SET password_hash = ?, activador = ? WHERE rut = ?")
        ->execute([$hash, $activador, $rut]);
    
    $msg = "<div style='background:#d4edda;color:#155724;padding:20px;border-radius:12px;'><strong>✅ ACTIVADOR CREADO:</strong> <code>$activador</code></div>";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>⚡ Panel Activación RUT+Cliente</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body{font-family:'Segoe UI',Arial,sans-serif;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;padding:30px;}
        .container{max-width:600px;margin:0 auto;}
        .header{background:linear-gradient(135deg,#77216F,#5E2750);color:white;padding:40px;border-radius:20px;text-align:center;}
        .form-container{background:white;padding:40px;border-radius:20px;margin:30px 0;box-shadow:0 15px 40px rgba(0,0,0,0.1);}
        input{padding:15px;border:2px solid #eee;border-radius:12px;width:100%;margin-bottom:20px;font-size:16px;}
        input:focus{outline:none;border-color:#77216F;box-shadow:0 0 0 3px rgba(119,33,111,0.1);}
        .btn-generate{width:100%;padding:18px;background:linear-gradient(135deg,#ffc107,#e0a800);color:#212529;border:none;border-radius:12px;font-size:18px;font-weight:600;cursor:pointer;}
        .activador{font-family:monospace;background:#f8f9fa;padding:20px;border-radius:10px;border-left:5px solid #28a745;font-size:16px;margin:20px 0;}
        .back-link{display:inline-block;background:#6c757d;color:white;padding:12px 25px;border-radius:10px;text-decoration:none;margin-top:20px;}
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-bolt"></i> Panel Activación</h1>
            <p>RUT + Nº Cliente + 3 Boletas</p>
        </div>

        <div class="form-container">
            <?php if($msg): echo $msg; endif; ?>
            
            <form method="POST">
                <input type="text" name="rut" placeholder="12.345.678-9" required>
                <input type="text" name="numero_cliente" placeholder="12345" required>
                <input type="text" name="boleta1" placeholder="Boleta 1: 67890" required>
                <input type="text" name="boleta2" placeholder="Boleta 2: 11111" required>
                <input type="text" name="boleta3" placeholder="Boleta 3: 22222" required>
                <button type="submit" class="btn-generate">
                    <i class="fas fa-magic"></i> GENERAR ACTIVADOR
                </button>
            </form>
            
            <div class="activador">
                <strong>Formato:</strong><br>
                odede>RUT+NºCliente+Boleta1+Boleta2+Boleta3</code><br><br>
                <strong>Ejemplo:</strong><br>
                odede>12.345.678-9+12345+67890+11111+22222</code>
            </div>

            <a href="index.php?p=dashboard" class="back-link">← Dashboard</a>
        </div>
    </div>
</body>
</html>
