<?php
session_start();
require_once 'config.php';
require_once 'rut.php';

function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }
function user() { return $_SESSION['user'] ?? null; }

$user = user();
if (!$user) {
    header('Location: index.php');
    exit;
}

$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

// SSR del socio
$ssr_id = $user['ssr_id'];
$stmt = $pdo->prepare("SELECT nombre FROM ssr WHERE id = ?");
$stmt->execute([$ssr_id]);
$ssr_nombre = $stmt->fetchColumn() ?: 'SSR';

// Solo rendiciones PUBLICADAS de SU SSR
$stmt = $pdo->prepare("
    SELECT r.*, s.nombre as ssr_nombre 
    FROM rendiciones r 
    JOIN ssr s ON r.ssr_id = s.id 
    WHERE r.ssr_id = ? AND r.estado = 'publicada'
    ORDER BY r.periodo_inicio DESC, r.id DESC
");
$stmt->execute([$ssr_id]);
$mis_rendiciones = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Mis Rendiciones - <?= e($ssr_nombre) ?></title>
    <style>
        :root{--primary:#77216F;--secondary:#5E2750;--success:#28a745;--orange:#E95420;--bg:#f7f5f3;--card:#fff;}
        body{font-family:Ubuntu,Arial,sans-serif;background:var(--bg);padding:20px;}
        .container{max-width:1000px;margin:0 auto;}
        .header{background:linear-gradient(135deg,var(--primary),var(--secondary));color:#fff;padding:30px;border-radius:12px;text-align:center;}
        .stats{display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px;margin:30px 0;}
        .stat{background:var(--card);padding:25px;border-radius:12px;text-align:center;border-top:4px solid var(--success);}
        table{width:100%;border-collapse:collapse;margin:30px 0;background:var(--card);border-radius:12px;overflow:hidden;box-shadow:0 8px 32px rgba(0,0,0,0.1);}
        th{background:linear-gradient(135deg,var(--primary),var(--secondary));color:#fff;padding:15px;text-align:left;}
        td{padding:15px;border-bottom:1px solid #eee;}
        tr:hover{background:#f8f9fa;}
        .btn{display:inline-block;padding:10px 20px;background:var(--orange);color:#fff;text-decoration:none;border-radius:8px;margin:5px;font-size:14px;}
        .btn:hover{background:var(--primary);}
        .btn-foro{background:var(--success);padding:10px 15px;font-size:16px;}
        .btn-foro:hover{background:#218838;}
        .no-results{text-align:center;padding:60px;background:var(--card);border-radius:12px;margin:30px 0;}
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h1>📄 Mis Rendiciones</h1>
        <p><?= e($user['nombre_completo']) ?> | <strong><?= e($ssr_nombre) ?></strong></p>
    </div>
    
    <div style="margin:20px 0;">
        <a href="index.php?p=dashboard" class="btn">← Dashboard</a>
        <a href="index.php" class="btn">🏠 Inicio</a>
    </div>

    <?php $total = count($mis_rendiciones); ?>
    <div class="stats">
        <div class="stat">
            <h3>📊 Total Públicas</h3>
            <h2 style="color:var(--success);"><?= $total ?></h2>
        </div>
        <div class="stat">
            <h3>🏢 Mi SSR</h3>
            <h2 style="color:var(--primary);"><?= e($ssr_nombre) ?></h2>
        </div>
    </div>

    <?php if(empty($mis_rendiciones)): ?>
    <div class="no-results">
        <h3>📭 No hay rendiciones públicas</h3>
        <p>Los administradores de <strong><?= e($ssr_nombre) ?></strong> publicarán pronto las rendiciones.</p>
        <a href="index.php?p=dashboard" class="btn">← Volver Dashboard</a>
    </div>
    <?php else: ?>
    <table>
        <tr>
            <th>Título</th>
            <th>Período</th>
            <th>PDF</th>
            <th>Foro</th>
            <th>Fecha</th>
        </tr>
        <?php foreach($mis_rendiciones as $r): ?>
        <tr>
            <td><strong><?= e($r['titulo']) ?></strong></td>
            <td><?= date('M/Y', strtotime($r['periodo_inicio'])) ?> - <?= date('M/Y', strtotime($r['periodo_fin'])) ?></td>
            <td>
                <?php if($r['pdf1']): ?>
                    <a href="uploads/<?= e($r['pdf1']) ?>" target="_blank" class="btn">📄 PDF</a>
                <?php else: ?>
                    <span style="color:#999;">— Sin PDF</span>
                <?php endif; ?>
            </td>
            <td><a href="foro_rendicion.php?id=<?= $r['id'] ?>" class="btn btn-foro">🗣️ Foro</a></td>
            <td><?= date('d-m-Y', strtotime($r['created_at'])) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
    <?php endif; ?>
</div>
</body>
</html>
