<?php
session_start();

function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }
function user() { return $_SESSION['user'] ?? null; }

$user = user();
$msg = $error = null;

if (!$user) {
    header('Location: index.php');
    exit;
}

$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $password_actual = $_POST['password_actual'] ?? '';
    $password_nueva = $_POST['password_nueva'] ?? '';
    $password_confirmar = $_POST['password_confirmar'] ?? '';

    if (!password_verify($password_actual, $user['password_hash'])) {
        $error = "❌ La contraseña actual es incorrecta.";
    } elseif (strlen($password_nueva) < 8) {
        $error = "❌ La nueva contraseña debe tener al menos 8 caracteres.";
    } elseif ($password_nueva !== $password_confirmar) {
        $error = "❌ Las contraseñas nuevas no coinciden.";
    } elseif ($password_actual === $password_nueva) {
        $error = "⚠️ La nueva contraseña debe ser diferente a la actual.";
    } else {
        $new_hash = password_hash($password_nueva, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE socios SET password_hash = ? WHERE id = ?");
        $stmt->execute([$new_hash, $user['id']]);
        $user['password_hash'] = $new_hash;
        $_SESSION['user'] = $user;
        $msg = "✅ Contraseña actualizada exitosamente.";
    }
}

// Obtener rol en texto
$rol_texto = $user['rol']==1 ? '🛡️ SuperAdmin' : ($user['rol']==2 ? '👑 Admin' : '👤 Socio');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mi Perfil - Sistema de Rendiciones</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { 
            --primary: #77216F; 
            --secondary: #5E2750; 
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        /* Header superior igual al dashboard */
        .top-bar {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 20px 30px;
            border-radius: 15px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 10px 30px rgba(119, 33, 111, 0.3);
        }

        .top-bar .user-info-header {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .top-bar .user-info-header strong {
            font-size: 1.1em;
        }

        .top-bar .user-info-header small {
            opacity: 0.9;
            font-size: 0.9em;
        }

        .top-bar .actions {
            display: flex;
            gap: 10px;
        }

        .btn-top {
            padding: 10px 20px;
            background: rgba(255,255,255,0.2);
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-size: 0.95em;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-top:hover {
            background: rgba(255,255,255,0.3);
            transform: translateY(-2px);
        }

        /* Container principal */
        .container {
            max-width: 900px;
            margin: 0 auto;
        }

        /* Card del perfil */
        .profile-card {
            background: white;
            border-radius: 15px;
            padding: 0;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
            margin-bottom: 20px;
        }

        .profile-header {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 30px;
            text-align: center;
        }

        .profile-header h1 {
            font-size: 2em;
            margin-bottom: 10px;
        }

        .profile-content {
            padding: 30px;
        }

        /* Info cards en grid */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .info-item {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            border-left: 4px solid var(--primary);
        }

        .info-item label {
            display: block;
            font-size: 0.85em;
            color: #6c757d;
            margin-bottom: 5px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .info-item .value {
            font-size: 1.1em;
            font-weight: 600;
            color: #333;
        }

        /* Sección de cambio de contraseña */
        .password-section {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 10px;
            margin-top: 20px;
        }

        .password-section h2 {
            color: var(--primary);
            margin-bottom: 20px;
            font-size: 1.5em;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
            font-size: 0.95em;
        }

        .form-group input {
            width: 100%;
            padding: 14px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s;
        }

        .form-group input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(119, 33, 111, 0.1);
        }

        .hint {
            font-size: 0.85em;
            color: #6c757d;
            margin-top: 5px;
        }

        /* Botones */
        .btn {
            padding: 14px 28px;
            border: none;
            border-radius: 8px;
            font-size: 1em;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
            width: 100%;
            justify-content: center;
        }

        .btn-primary:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(119, 33, 111, 0.3);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
            width: 100%;
            justify-content: center;
            margin-top: 10px;
        }

        .btn-secondary:hover {
            background: #5a6268;
        }

        /* Mensajes */
        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 500;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid var(--success);
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid var(--danger);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .top-bar {
                flex-direction: column;
                gap: 15px;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Barra superior -->
    <div class="top-bar">
        <div class="user-info-header">
            <i class="fas fa-user-circle fa-2x"></i>
            <div>
                <strong><?= e($user['nombre_completo']) ?></strong>
                <br>
                <small><?= e($user['ssr_nombre'] ?? 'GLOBAL') ?> | <?= $rol_texto ?></small>
            </div>
        </div>
        <div class="actions">
            <a href="index.php?p=dashboard" class="btn-top">
                <i class="fas fa-th-large"></i> Dashboard
            </a>
            <a href="index.php?logout=1" class="btn-top">
                <i class="fas fa-sign-out-alt"></i> Salir
            </a>
        </div>
    </div>

    <div class="container">
        <!-- Card principal del perfil -->
        <div class="profile-card">
            <div class="profile-header">
                <h1><i class="fas fa-user-circle"></i> Mi Perfil</h1>
                <p>Gestiona tu información personal y seguridad</p>
            </div>

            <div class="profile-content">
                <!-- Grid de información del usuario -->
                <div class="info-grid">
                    <div class="info-item">
                        <label><i class="fas fa-id-card"></i> RUT</label>
                        <div class="value"><?= e($user['rut']) ?></div>
                    </div>
                    <div class="info-item">
                        <label><i class="fas fa-envelope"></i> Email</label>
                        <div class="value"><?= e($user['email']) ?></div>
                    </div>
                    <div class="info-item">
                        <label><i class="fas fa-building"></i> SSR</label>
                        <div class="value"><?= e($user['ssr_nombre'] ?? 'No asignado') ?></div>
                    </div>
                    <div class="info-item">
                        <label><i class="fas fa-user-tag"></i> Rol</label>
                        <div class="value"><?= $rol_texto ?></div>
                    </div>
                </div>

                <!-- Sección de cambio de contraseña -->
                <div class="password-section">
                    <h2>
                        <i class="fas fa-key"></i>
                        Cambiar Contraseña
                    </h2>

                    <?php if($msg): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> <?= $msg ?>
                    </div>
                    <?php elseif($error): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i> <?= $error ?>
                    </div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="form-group">
                            <label for="password_actual">
                                <i class="fas fa-lock"></i> Contraseña Actual
                            </label>
                            <input 
                                type="password" 
                                id="password_actual" 
                                name="password_actual" 
                                required 
                                autocomplete="current-password"
                                placeholder="Ingresa tu contraseña actual"
                            >
                        </div>

                        <div class="form-group">
                            <label for="password_nueva">
                                <i class="fas fa-key"></i> Nueva Contraseña
                            </label>
                            <input 
                                type="password" 
                                id="password_nueva" 
                                name="password_nueva" 
                                required 
                                autocomplete="new-password"
                                placeholder="Mínimo 8 caracteres"
                            >
                            <div class="hint">
                                <i class="fas fa-info-circle"></i> 
                                Debe tener al menos 8 caracteres
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="password_confirmar">
                                <i class="fas fa-key"></i> Confirmar Nueva Contraseña
                            </label>
                            <input 
                                type="password" 
                                id="password_confirmar" 
                                name="password_confirmar" 
                                required 
                                autocomplete="new-password"
                                placeholder="Repite la nueva contraseña"
                            >
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Actualizar Contraseña
                        </button>

                        <a href="index.php?p=dashboard" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver al Dashboard
                        </a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
