<?php
session_start();

// ✅ USAR config.php QUE FUNCIONA
$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rut = trim($_POST['rut']);
    $password = $_POST['password'];
    
    // Al loguear, obtener el nombre del SSR con un JOIN
    $stmt = $pdo->prepare("SELECT s.*, r.nombre as ssr_nombre FROM socios s LEFT JOIN ssr r ON s.ssr_id = r.id WHERE (s.rut = ? OR s.email = ?) AND s.activo = 1");
    $stmt->execute([$rut, $rut]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user'] = $user;
        header('Location: /index.php?p=dashboard');
        exit;
    } else {
        $error = "❌ RUT/Email o contraseña incorrectos";
    }
}

$p = $_GET['p'] ?? '';
if ($p === 'dashboard') {
    $user = $_SESSION['user'] ?? null;
    if (!$user) {
        header('Location: /index.php');
        exit;
    }
    ?>
    <!DOCTYPE html>
    <html>
    <head><!-- Buscar la sección del header del dashboard y modificar: -->
<div style="background:linear-gradient(135deg,#77216F,#5E2750); color:white; padding:30px; border-radius:15px; margin-bottom:20px;">
    <div style="display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:15px;">
        <div>
            <h1><i class="fas fa-th-large"></i> Dashboard SSR Completo</h1>
            <p style="margin-top:10px;">
                <strong><?= e($user['nombre_completo']) ?></strong> | 
                <?= e($user['ssr_nombre'] ?? 'GLOBAL') ?>
                <br>
                <span style="font-size:0.9em; opacity:0.9;">
                    <?= $user['rol']==1?'🛡️ SuperAdmin':($user['rol']==2?'👑 Admin':'👤 Socio') ?>
                </span>
            </p>
        </div>
        <!-- ✨ Botones de acción en el header -->
        <div style="display:flex; gap:10px;">
            <a href="perfil.php" style="padding:12px 24px; background:rgba(255,255,255,0.2); color:white; text-decoration:none; border-radius:8px; display:inline-flex; align-items:center; gap:8px; transition:all 0.3s;">
                <i class="fas fa-user-circle"></i> Mi Perfil
            </a>
            <a href="index.php?logout=1" style="padding:12px 24px; background:rgba(255,255,255,0.2); color:white; text-decoration:none; border-radius:8px; display:inline-flex; align-items:center; gap:8px; transition:all 0.3s;">
                <i class="fas fa-sign-out-alt"></i> Salir
            </a>
        </div>
    </div>
</div>

        <title>🚀 Dashboard SSR Completo</title>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <style>
            body{font-family:'Segoe UI',Arial,sans-serif;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;padding:20px;}
            .header{background:linear-gradient(135deg,#77216F,#5E2750);color:white;padding:40px;border-radius:20px;text-align:center;box-shadow:0 15px 35px rgba(119,33,111,0.3);}
            .stats{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;margin:30px 0;}
            .stat{background:white;padding:30px;border-radius:15px;text-align:center;box-shadow:0 10px 30px rgba(0,0,0,0.1);}
            .stat h3{color:#666;margin:0 0 15px 0;}
            .stat h2{color:#77216F;font-size:2.5em;margin:0;}
            .menu{background:white;padding:30px;border-radius:15px;margin:20px 0;box-shadow:0 10px 30px rgba(0,0,0,0.1);}
            .menu h3{margin-bottom:20px;color:#333;}
            .btn{display:inline-block;padding:15px 30px;background:#28a745;color:white;text-decoration:none;border-radius:10px;margin:10px;font-weight:600;font-size:16px;transition:all 0.3s;}
            .btn:hover{transform:translateY(-3px);box-shadow:0 10px 25px rgba(40,167,69,0.4);}
            .btn-danger{background:#dc3545;}
            .btn-danger:hover{box-shadow:0 10px 25px rgba(220,53,69,0.4);}
            .btn-warning{background:#ffc107;color:#212529;}
            .btn-warning:hover{box-shadow:0 10px 25px rgba(255,193,7,0.4);}
            .btn-info{background:#17a2b8;}
            .btn-info:hover{box-shadow:0 10px 25px rgba(23,162,184,0.4);}
            @media(max-width:768px){.stats{grid-template-columns:1fr;}}
            
            /* ESTILOS PARA EL NUEVO MENÚ DE ADMINISTRACIÓN */
            .admin-link {
                background: var(--bg-color, #333);
                color: white;
                padding: 20px;
                border-radius: 12px;
                text-decoration: none;
                transition: transform 0.2s, box-shadow 0.2s;
                box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            }

            .admin-link:hover {
                transform: translateY(-5px);
                box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            }

            .admin-link h3 {
                margin-bottom: 10px;
                font-size: 1.25rem;
            }

            .admin-link p {
                font-size: 0.9rem;
                opacity: 0.9;
            }
        </style>
    </head>
    <body>
        <div class="header">
            <h1><i class="fas fa-tachometer-alt"></i> Dashboard SSR Completo</h1>
            <p><strong><?= e($user['nombre_completo']) ?></strong> | <?= e($user['ssr_nombre'] ?? 'GLOBAL') ?></p>
            <p><?= $user['rol']==1?'🛡️ SuperAdmin':($user['rol']==2?'👑 Admin':'👤 Socio') ?></p>
        </div>

        <div class="stats">
            <div class="stat">
                <h3>👥 Socios Total (Mi SSR)</h3>
                <h2><?= $pdo->query("SELECT COUNT(*) FROM socios WHERE ssr_id = {$user['ssr_id']}")->fetchColumn() ?></h2>
            </div>
            <div class="stat">
                <h3>📊 Rendiciones (Mi SSR)</h3>
                <h2><?= $pdo->query("SELECT COUNT(*) FROM rendiciones WHERE ssr_id = {$user['ssr_id']}")->fetchColumn() ?></h2>
            </div>
            <div class="stat">
                <h3>🏢 SSR ID</h3>
                <h2><?= $user['ssr_id'] ?></h2>
            </div>
            <?php if($user['rol'] == 1): ?>
            <div class="stat">
                <h3>🌐 Total SSR</h3>
                <h2><?= $pdo->query("SELECT COUNT(*) FROM ssr")->fetchColumn() ?></h2>
            </div>
            <?php endif; ?>
        </div>

        <?php if ($user['rol'] <= 2): // Solo visible para Superadmin (1) y Admin SSR (2) ?>
        <div class="card-admin" style="margin-top: 40px;">
            <h2 style="color: #77216F; margin-bottom: 20px;"><i class="fas fa-tools"></i> Herramientas de Administración</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">

                <a href="admin_socios.php" class="admin-link" style="--bg-color: #0d6efd;">
                    <h3><i class="fas fa-users"></i> Gestión de Socios</h3>
                    <p>Crear, editar y desactivar usuarios.</p>
                </a>

                <?php if ($user['rol'] == 1): // Solo visible para Superadmin (1) ?>
                <a href="admin_ssr.php" class="admin-link" style="--bg-color: #77216F;">
                    <h3><i class="fas fa-building"></i> Gestión de SSR (Empresas)</h3>
                    <p>Crear y administrar las entidades.</p>
                </a>
                <?php endif; ?>

                <a href="socios_importar.php" class="admin-link" style="--bg-color: #198754;">
                    <h3><i class="fas fa-file-csv"></i> Importar Socios</h3>
                    <p>Carga masiva de usuarios vía CSV.</p>
                </a>
                
                <a href="ver_activadores.php" class="admin-link" style="--bg-color: #ffc107; color: #333;">
                    <h3><i class="fas fa-bolt"></i> Códigos Activadores</h3>
                    <p>Ver y generar códigos de activación.</p>
                </a>

            </div>
        </div>
        <?php endif; ?>
        <div class="menu">
            <h3>🔧 ADMINISTRACIÓN PRINCIPAL:</h3>
            <?php if($user['rol'] <= 2): ?>
            <a href="admin_socios.php" class="btn">👥 Gestión Socios</a>
            <a href="socios_importar.php" class="btn btn-warning">📁 Carga Masiva CSV</a>
            <?php endif; ?>
            
            <a href="/rendiciones_públicas.php?ssr=<?= $user['ssr_id'] ?>" target="_blank" class="btn btn-info">👁️ Vista Pública</a>
            
            <?php if($user['rol'] <= 2): ?>
            <a href="rendiciones_admin.php" class="btn">📋 Gestionar Rendiciones</a>
            <?php endif; ?>

            <h3 style="margin-top:30px;">🔑 SISTEMA DE ACTIVACIÓN:</h3>
            <a href="/activacion.php" class="btn btn-warning">⚡ Panel Activación RUT+Cliente</a>
            <a href="/ver_activadores.php" class="btn">🔍 Ver Códigos Activador</a>
            <!-- En la sección del menú/navegación del dashboard -->
            <a href="perfil.php" class="menu-link">
            <i class="fas fa-user-circle"></i> Mi Perfil
            </a>
            <a href="index.php?logout=1" class="btn btn-danger">🚪 Salir</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema SSR</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #2563eb;
            --primary-dark: #1e40af;
            --surface: #ffffff;
            --background: #f1f5f9;
            --text: #1e293b;
            --text-light: #64748b;
            --border: #e2e8f0;
            --shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.6;
        }

        /* Topbar */
        .topbar {
            background: var(--surface);
            border-bottom: 1px solid var(--border);
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: var(--shadow);
        }

        .topbar-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding-left: 1.5rem;
            border-left: 1px solid var(--border);
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: var(--primary);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .user-details {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--text);
        }

        .user-role {
            font-size: 0.8rem;
            color: var(--text-light);
        }

        .topbar-actions {
            display: flex;
            gap: 0.5rem;
        }

        .btn {
            padding: 0.6rem 1.2rem;
            border-radius: 0.5rem;
            font-size: 0.9rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            border: none;
        }

        .btn-ghost {
            background: transparent;
            color: var(--text-light);
        }

        .btn-ghost:hover {
            background: var(--background);
            color: var(--text);
        }

        /* Container */
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2.5rem;
        }

        .stat-card {
            background: var(--surface);
            padding: 1.5rem;
            border-radius: 0.75rem;
            border: 1px solid var(--border);
            transition: all 0.2s;
        }

        .stat-card:hover {
            box-shadow: var(--shadow-lg);
            transform: translateY(-2px);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .stat-label {
            font-size: 0.85rem;
            color: var(--text-light);
            font-weight: 500;
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            background: #eff6ff;
            color: var(--primary);
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }

        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: var(--text);
        }

        /* Section */
        .section {
            margin-bottom: 2.5rem;
        }

        .section-header {
            margin-bottom: 1.5rem;
        }

        .section-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--text);
            margin-bottom: 0.25rem;
        }

        .section-subtitle {
            font-size: 0.9rem;
            color: var(--text-light);
        }

        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
        }

        .card {
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            cursor: pointer;
            transition: all 0.2s;
        }

        .card:hover {
            box-shadow: var(--shadow-lg);
            transform: translateY(-2px);
            border-color: var(--primary);
        }

        .card-icon {
            width: 48px;
            height: 48px;
            background: #eff6ff;
            color: var(--primary);
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }

        .card-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--text);
            margin-bottom: 0.5rem;
        }

        .card-description {
            font-size: 0.9rem;
            color: var(--text-light);
            line-height: 1.5;
        }

        /* Action Buttons */
        .actions-list {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .btn-action {
            padding: 0.75rem 1.5rem;
            background: var(--surface);
            color: var(--text);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            text-decoration: none;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.2s;
        }

        .btn-action:hover {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
            transform: translateY(-1px);
            box-shadow: var(--shadow);
        }

        .btn-action i {
            font-size: 1.1rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .topbar {
                flex-direction: column;
                gap: 1rem;
                padding: 1rem;
            }

            .user-info {
                border-left: none;
                border-top: 1px solid var(--border);
                padding-left: 0;
                padding-top: 1rem;
                width: 100%;
            }

            .container {
                padding: 1rem;
            }

            .stats-grid,
            .cards-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Topbar -->
    <div class="topbar">
        <div class="topbar-left">
            <div class="logo">
                <i class="fas fa-water"></i> Sistema SSR
            </div>
            <div class="user-info">
                <div class="user-avatar">
                    <?= strtoupper(substr($user['nombre_completo'], 0, 2)) ?>
                </div>
                <div class="user-details">
                    <span class="user-name"><?= e($user['nombre_completo']) ?></span>
                    <span class="user-role"><?= $rol_texto ?> · <?= e($user['ssr_nombre'] ?? 'Global') ?></span>
                </div>
            </div>
        </div>
        <div class="topbar-actions">
            <a href="perfil.php" class="btn btn-ghost">
                <i class="fas fa-user-circle"></i> Perfil
            </a>
            <a href="index.php?logout=1" class="btn btn-ghost">
                <i class="fas fa-sign-out-alt"></i> Salir
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container">
        <!-- Stats -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-header">
                    <span class="stat-label">Socios Totales</span>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
                <div class="stat-value">5</div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <span class="stat-label">Rendiciones</span>
                    <div class="stat-icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                </div>
                <div class="stat-value">3</div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <span class="stat-label">Mi SSR ID</span>
                    <div class="stat-icon">
                        <i class="fas fa-building"></i>
                    </div>
                </div>
                <div class="stat-value">1</div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <span class="stat-label">Total SSR</span>
                    <div class="stat-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                </div>
                <div class="stat-value">2</div>
            </div>
        </div>

        <!-- Administración -->
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">Administración</h2>
                <p class="section-subtitle">Herramientas de gestión del sistema</p>
            </div>
            <div class="cards-grid">
                <div class="card" onclick="location.href='admin_socios.php'">
                    <div class="card-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="card-title">Gestión de Socios</h3>
                    <p class="card-description">Crear, editar y administrar usuarios del sistema</p>
                </div>

                <div class="card" onclick="location.href='admin_ssr.php'">
                    <div class="card-icon">
                        <i class="fas fa-building"></i>
                    </div>
                    <h3 class="card-title">Gestión de SSR</h3>
                    <p class="card-description">Administrar comités y entidades del sistema</p>
                </div>

                <div class="card" onclick="location.href='socios_importar.php'">
                    <div class="card-icon">
                        <i class="fas fa-file-upload"></i>
                    </div>
                    <h3 class="card-title">Importar Socios</h3>
                    <p class="card-description">Carga masiva de usuarios mediante CSV</p>
                </div>

                <div class="card" onclick="location.href='activacion.php'">
                    <div class="card-icon">
                        <i class="fas fa-qrcode"></i>
                    </div>
                    <h3 class="card-title">Códigos Activadores</h3>
                    <p class="card-description">Generar y gestionar códigos de activación</p>
                </div>
            </div>
        </div>

        <!-- Acciones Rápidas -->
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">Acciones Rápidas</h2>
            </div>
            <div class="actions-list">
                <a href="rendiciones_admin.php" class="btn-action">
                    <i class="fas fa-file-alt"></i>
                    Gestionar Rendiciones
                </a>
                <a href="rendiciones_publicas.php" class="btn-action">
                    <i class="fas fa-eye"></i>
                    Vista Pública
                </a>
                <a href="nueva_rendicion.php" class="btn-action">
                    <i class="fas fa-plus-circle"></i>
                    Nueva Rendición
                </a>
                <a href="ver_activadores.php" class="btn-action">
                    <i class="fas fa-key"></i>
                    Ver Códigos
                </a>
            </div>
        </div>
    </div>
</body>
</html>