<?php
/**
 * TEMPLATE: HEADER (Versión Reparada y Definitiva)
 * Este archivo es el controlador principal para todas las páginas autenticadas.
 * Se encarga de la seguridad, la conexión a la base de datos y la carga de funciones.
 */

// 1. INICIAR LA SESIÓN DE FORMA SEGURA
// Esto evita errores si la sesión ya fue iniciada en otro lugar (aunque no debería pasar).
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 2. CARGAR LA CONFIGURACIÓN CENTRAL
// La ruta sube un nivel desde /templates para encontrar la carpeta /config.
// Este archivo define APP_ROOT y BASE_URL.
require_once dirname(__DIR__) . '/config/configuracion.php';

// 3. CARGAR LA CONEXIÓN Y CREAR LA VARIABLE GLOBAL `$conn`
// Primero, cargamos el archivo que crea la variable `$conexion`.
require_once dirname(__DIR__) . '/config/conexion.php'; 
// Luego, creamos la variable `$conn` que todas tus funciones esperan.
$conn = $conexion;

// 4. BARRERA DE SEGURIDAD
// Verificamos si el usuario está autenticado. Si no, lo redirigimos al login.
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

// 5. CARGAR LAS FUNCIONES COMUNES
// Ahora que `$conn` existe globalmente, estas funciones operarán correctamente.
require_once APP_ROOT . '/lib/funciones_comunes.php';

// 6. OBTENER DATOS DEL USUARIO ACTUAL
// La función `obtener_usuario_actual()` usará la variable global `$conn`.
$usuario_actual = obtener_usuario_actual(); 

// Por seguridad, si por alguna razón el usuario de la sesión no existe en la BD, forzamos un logout.
if (!$usuario_actual) {
    header('Location: ' . BASE_URL . 'logout');
    exit;
}

// 7. PREPARAR VARIABLES PARA LA VISTA
$nombre_usuario = $usuario_actual['nombre'] ?? 'Usuario';
$iniciales_usuario = strtoupper(substr($nombre_usuario, 0, 2));

// Determinar la ruta actual para marcar el menú como "activo".
$url_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$base_path = parse_url(BASE_URL, PHP_URL_PATH);
$current_route = str_replace($base_path, '', $url_path);
$current_route = trim($current_route, '/');
$route_parts = explode('/', $current_route);
$main_route = $route_parts[0];

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? sanitizar_html($page_title) . ' | ' . NOMBRE_SISTEMA : NOMBRE_SISTEMA; ?></title>
    <!-- La ruta al CSS usa BASE_URL y se añade una versión para evitar problemas de caché -->
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>assets/css/estilos.css?v=<?php echo time(); ?>">
</head>
<body>
    <div class="page-container">
        
        <!-- Menú Lateral (Sidebar) -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <a href="<?php echo BASE_URL; ?>dashboard" class="sidebar-brand"><?php echo NOMBRE_SISTEMA; ?></a>
            </div>
            <nav class="sidebar-nav">
                <a href="<?php echo BASE_URL; ?>dashboard" class="<?php echo ($main_route == 'dashboard' || $main_route == '') ? 'active' : ''; ?>">Dashboard</a>
                <a href="<?php echo BASE_URL; ?>casos" class="<?php echo ($main_route == 'casos') ? 'active' : ''; ?>">Casos</a>
                <a href="<?php echo BASE_URL; ?>clientes" class="<?php echo ($main_route == 'clientes') ? 'active' : ''; ?>">Clientes</a>
                <a href="<?php echo BASE_URL; ?>reportes" class="<?php echo ($main_route == 'reportes') ? 'active' : ''; ?>">Reportes</a>
            </nav>
            <div class="sidebar-footer">
                <div class="user-info">
                    <div class="user-avatar"><?php echo $iniciales_usuario; ?></div>
                    <span><?php echo sanitizar_html($nombre_usuario); ?></span>
                </div>
                <a href="<?php echo BASE_URL; ?>logout" class="logout-button" title="Cerrar Sesión">&#x27A9;</a>
            </div>
        </aside>

        <!-- Contenido Principal -->
        <main class="main-content">
