<?php
// private/libs/funciones_email.php

// Incluir las clases de PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/../vendor/PHPMailer/Exception.php';
require_once __DIR__ . '/../vendor/PHPMailer/PHPMailer.php';
require_once __DIR__ . '/../vendor/PHPMailer/SMTP.php';

/**
 * Envía un correo electrónico usando PHPMailer con SMTP.
 *
 * @param string $destinatarioEmail El email del destinatario.
 * @param string $destinatarioNombre El nombre del destinatario.
 * @param string $asunto El asunto del correo.
 * @param string $cuerpoHTML El contenido del correo en formato HTML.
 * @return bool True si el correo se envió, false en caso contrario.
 */
function enviar_email($destinatarioEmail, $destinatarioNombre, $asunto, $cuerpoHTML) {
    
    $mail = new PHPMailer(true);

    try {
        // --- CONFIGURACIÓN DEL SERVIDOR SMTP ---
        // Estas credenciales debes obtenerlas de tu proveedor de hosting (cPanel)
        // o del servicio que uses para enviar correos (Gmail, SendGrid, etc.)
        
        $mail->isSMTP();
        $mail->Host       = 'smtp.example.com';  // Reemplaza con tu servidor SMTP
        $mail->SMTPAuth   = true;
        $mail->Username   = 'tu_email@example.com'; // Reemplaza con tu usuario SMTP (generalmente tu email)
        $mail->Password   = 'tu_contraseña_smtp'; // Reemplaza con tu contraseña SMTP
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // O 'ssl'
        $mail->Port       = 587; // Puerto SMTP (587 para TLS, 465 para SSL)

        // --- REMITENTE Y DESTINATARIO ---
        $mail->setFrom('no-reply@comite-ssr.cl', 'Portal de Reclamos SSR');
        $mail->addAddress($destinatarioEmail, $destinatarioNombre);

        // --- CONTENIDO DEL CORREO ---
        $mail->isHTML(true);
        $mail->CharSet = 'UTF-8';
        $mail->Subject = $asunto;
        $mail->Body    = $cuerpoHTML;
        $mail->AltBody = strip_tags($cuerpoHTML); // Versión en texto plano

        $mail->send();
        return true;

    } catch (Exception $e) {
        // En un entorno de producción, es crucial registrar el error en lugar de mostrarlo.
        error_log("Error al enviar email: {$mail->ErrorInfo}");
        return false;
    }
}
