<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal del Cliente - Iniciar Sesión</title>
    
    <!-- Bootstrap (base) y nuestra nueva hoja de estilos personalizada -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/portal_styles.css"> <!-- ¡NUEVO! -->
</head>
<body>

    <div class="portal-container">
        <div class="portal-card">
            <div class="portal-header">
                <h2>Portal de Clientes SSR</h2>
                <p>Bienvenido. Ingrese para gestionar sus casos.</p>
            </div>
            
            <!-- Contenedor para mensajes de error o éxito -->
            <div id="mensaje-login" class="mb-3"></div>

            <form id="login-form" method="POST" action="">
                <div class="mb-3">
                    <label for="email" class="form-label">Correo Electrónico</label>
                    <input type="email" class="form-control" id="email" name="email" required autocomplete="email">
                </div>
                <div class="mb-4">
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" class="form-control" id="password" name="password" required autocomplete="current-password">
                </div>
                <div class="d-grid">
                    <button type="submit" id="submit-btn" class="btn btn-portal-primary">Iniciar Sesión</button>
                </div>
            </form>

            <div class="portal-links">
                <a href="recuperar_password.php">¿Olvidaste tu contraseña?</a>
                <span class="mx-2">|</span>
                <a href="registro.php">Crear una cuenta</a>
            </div>
        </div>
    </div>

    <!-- El JavaScript no cambia, la funcionalidad es la misma -->
    <script src="../assets/js/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#login-form').on('submit', function(e) {
                e.preventDefault(); 
                $('#submit-btn').prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verificando...');

                $.ajax({
                    type: 'POST',
                    url: '../private/controllers/portal/auth_controller.php?action=login',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            $('#mensaje-login').html('<div class="alert alert-success">¡Éxito! Redirigiendo...</div>');
                            setTimeout(function() { window.location.href = 'dashboard.php'; }, 1000);
                        } else {
                            $('#mensaje-login').html('<div class="alert alert-danger">' + response.message + '</div>');
                            $('#submit-btn').prop('disabled', false).text('Iniciar Sesión');
                        }
                    },
                    error: function() {
                        $('#mensaje-login').html('<div class="alert alert-danger">Error de comunicación.</div>');
                        $('#submit-btn').prop('disabled', false).text('Iniciar Sesión');
                    }
                });
            });
        });
    </script>
</body>
</html>
