<?php
// 1. Seguridad y conexión
require_once __DIR__ . '/../private/controllers/portal/portal_seguridad.php';
require_once __DIR__ . '/../../conexion.php';

// 2. Validar ID y obtener datos de sesión
$caso_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$cliente_id = $_SESSION['cliente_id'];

if (!$caso_id) {
    die("ID de caso no válido.");
}

// 3. Verificar que el caso (y el archivo) pertenecen al cliente logueado
$stmt = $conexion->prepare("SELECT ruta_adjunto FROM casos WHERE id = ? AND id_cliente = ?");
$stmt->bind_param("ii", $caso_id, $cliente_id);
$stmt->execute();
$resultado = $stmt->get_result();
$caso = $resultado->fetch_assoc();
$stmt->close();

// 4. Si el caso existe, pertenece al cliente y tiene un adjunto, proceder a la descarga
if ($caso && !empty($caso['ruta_adjunto'])) {
    $nombre_archivo = $caso['ruta_adjunto'];
    $ruta_completa = __DIR__ . '/../private/uploads/' . $nombre_archivo;

    if (file_exists($ruta_completa)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="' . basename($nombre_archivo) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($ruta_completa));
        readfile($ruta_completa);
        exit;
    } else {
        die("Error: El archivo no se encuentra en el servidor.");
    }
} else {
    // Si no, denegar acceso
    die("Acceso denegado o el caso no tiene archivo adjunto.");
}
?>
