<?php
// Proteger la página. Solo clientes logueados pueden entrar.
require_once __DIR__ . '/../private/controllers/portal/portal_seguridad.php';

// Mostrar mensajes de error/éxito si existen
$mensaje = $_SESSION['mensaje'] ?? null;
unset($_SESSION['mensaje']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Nuevo Caso</title>
    <link rel="stylesheet" href="../assets/css/main.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">Portal Clientes SSR</a>
            <div class="d-flex">
                <span class="navbar-text me-3">
                    Hola, <?php echo htmlspecialchars($_SESSION['cliente_nombre']); ?>
                </span>
                <a href="logout.php" class="btn btn-outline-danger">Cerrar Sesión</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Crear Nuevo Caso</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($mensaje): ?>
                            <div class="alert alert-<?php echo $mensaje['tipo']; ?>">
                                <?php echo $mensaje['texto']; ?>
                            </div>
                        <?php endif; ?>

                        <form action="../private/controllers/portal/casos_controller.php?action=create" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="tipificacion" class="form-label">Tipo de Caso</label>
                                <select class="form-select" id="tipificacion" name="tipificacion" required>
                                    <option value="">Seleccione una opción...</option>
                                    <option value="reclamo">Reclamo</option>
                                    <option value="consulta">Consulta</option>
                                    <option value="sugerencia">Sugerencia</option>
                                    <option value="felicitacion">Felicitación</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="descripcion" class="form-label">Descripción Detallada</label>
                                <textarea class="form-control" id="descripcion" name="descripcion" rows="6" required></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="adjunto" class="form-label">Adjuntar Archivo (Opcional, solo PDF, máx 5MB)</label>
                                <input class="form-control" type="file" id="adjunto" name="adjunto" accept=".pdf">
                            </div>
                            <div class="d-flex justify-content-end">
                                <a href="dashboard.php" class="btn btn-secondary me-2">Cancelar</a>
                                <button type="submit" class="btn btn-primary">Enviar Caso</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
