<?php
// private/controllers/portal/casos_controller.php

require_once __DIR__ . '/portal_seguridad.php'; // Seguridad primero.
require_once __DIR__ . '/../../../../conexion.php'; // Conexión a la BD.

$action = $_GET['action'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'create') {
    handle_create_case();
} else {
    // Redirigir si se accede de forma incorrecta
    header('Location: ../../../portal/dashboard.php');
    exit;
}

function handle_create_case() {
    global $conexion;

    // Recoger datos del formulario
    $tipificacion = $_POST['tipificacion'] ?? '';
    $descripcion = $_POST['descripcion'] ?? '';
    $cliente_id = $_SESSION['cliente_id'];
    $empresa_id = $_SESSION['cliente_id_empresa'];
    $ruta_adjunto = null;

    // Validaciones básicas
    if (empty($tipificacion) || empty($descripcion)) {
        set_mensaje('Todos los campos son obligatorios.', 'danger');
        header('Location: ../../../portal/crear_caso.php');
        exit;
    }

    // 1. Manejo del archivo adjunto
    if (isset($_FILES['adjunto']) && $_FILES['adjunto']['error'] == 0) {
        $archivo = $_FILES['adjunto'];
        $limite_mb = 5;
        $tipos_permitidos = ['application/pdf'];

        if ($archivo['size'] > $limite_mb * 1024 * 1024) {
            set_mensaje('El archivo es demasiado grande. El límite es de 5MB.', 'danger');
            header('Location: ../../../portal/crear_caso.php');
            exit;
        }

        if (!in_array($archivo['type'], $tipos_permitidos)) {
            set_mensaje('Tipo de archivo no permitido. Solo se aceptan archivos PDF.', 'danger');
            header('Location: ../../../portal/crear_caso.php');
            exit;
        }

        // Crear un nombre de archivo único para evitar sobreescrituras
        $nombre_unico = time() . '-' . uniqid() . '-' . basename($archivo['name']);
        $directorio_destino = __DIR__ . '/../../../uploads/'; // Ruta a la carpeta /private/uploads/
        $ruta_completa = $directorio_destino . $nombre_unico;

        if (move_uploaded_file($archivo['tmp_name'], $ruta_completa)) {
            $ruta_adjunto = $nombre_unico; // Guardamos solo el nombre del archivo en la BD
        } else {
            set_mensaje('Error al subir el archivo adjunto.', 'danger');
            header('Location: ../../../portal/crear_caso.php');
            exit;
        }
    }

    // 2. Insertar en la base de datos
    $estado_inicial = 'NUEVO';
    $origen = 'Portal Cliente';
    
    $stmt = $conexion->prepare(
        "INSERT INTO casos (id_cliente, id_empresa, tipificacion, descripcion, estado, origen, fecha_creacion, ruta_adjunto) 
         VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)"
    );
    $stmt->bind_param("issssss", $cliente_id, $empresa_id, $tipificacion, $descripcion, $estado_inicial, $origen, $ruta_adjunto);

    if ($stmt->execute()) {
        set_mensaje('Su caso ha sido creado exitosamente.', 'success');
        // Aquí podríamos añadir la lógica para enviar email de notificación
    } else {
        set_mensaje('Error al crear el caso en la base de datos.', 'danger');
    }
    
    $stmt->close();
    header('Location: ../../../portal/dashboard.php');
    exit;
}

/**
 * Función auxiliar para establecer mensajes de sesión (flash messages).
 */
function set_mensaje($texto, $tipo) {
    $_SESSION['mensaje'] = [
        'texto' => $texto,
        'tipo' => $tipo
    ];
}
?>
