<?php
// /modulos/dashboard.php

// 1. Definir el título de la página
$page_title = 'Dashboard';

// 2. Incluir el header.
// La ruta sube dos niveles desde /modulos/ para llegar a la raíz y entrar a /templates.
require_once dirname(__DIR__, 2) . '/templates/header.php';

// La variable $conn ya está disponible aquí gracias al header.

// --- Lógica para obtener datos REALES del Dashboard ---
$query_total = "SELECT COUNT(id) as total FROM casos";
$total_casos = $conn->query($query_total)->fetch_assoc()['total'] ?? 0;

$query_abiertos = "SELECT COUNT(id) as abiertos FROM casos WHERE estado != 'CERRADO'";
$casos_abiertos = $conn->query($query_abiertos)->fetch_assoc()['abiertos'] ?? 0;

$query_clientes = "SELECT COUNT(id) as total FROM clientes";
$total_clientes = $conn->query($query_clientes)->fetch_assoc()['total'] ?? 0;
?>

<!-- HTML de la página -->
<div class="page-header">
    <h1><?php echo $page_title; ?></h1>
    <p>Resumen general del estado del sistema.</p>
</div>

<div class="dashboard-grid">
    <div class="card card-stat">
        <h3><?php echo $total_casos; ?></h3>
        <p>Total de Casos</p>
    </div>
    <div class="card card-stat card-stat-warning">
        <h3><?php echo $casos_abiertos; ?></h3>
        <p>Casos Abiertos</p>
    </div>
    <div class="card card-stat card-stat-info">
        <h3><?php echo $total_clientes; ?></h3>
        <p>Total de Clientes</p>
    </div>
</div>

<?php
// 3. Incluir el footer.
require_once dirname(__DIR__, 2) . '/templates/footer.php';
?>
