<?php
// Módulo: Listar Clientes
$page_title = 'Listado de Clientes';
require_once dirname(dirname(__DIR__)) . '/templates/header.php';

// --- Lógica de Paginación y Búsqueda ---
if (!defined('RECORDS_PER_PAGE')) {
    define('RECORDS_PER_PAGE', 10);
}
$termino_busqueda = isset($_GET['q']) ? trim($_GET['q']) : '';
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * RECORDS_PER_PAGE;

// Contar registros
$sql_count = "SELECT COUNT(id) as total FROM clientes WHERE empresa_id = ?";
$params_count = [$empresa_id];
$types_count = "i";
if (!empty($termino_busqueda)) {
    $sql_count .= " AND (nombre LIKE ? OR rut LIKE ? OR email LIKE ?)";
    $param_busqueda = "%" . $termino_busqueda . "%";
    array_push($params_count, $param_busqueda, $param_busqueda, $param_busqueda);
    $types_count .= "sss";
}
$stmt_count = $conn->prepare($sql_count);
$stmt_count->bind_param($types_count, ...$params_count);
$stmt_count->execute();
$total_records = $stmt_count->get_result()->fetch_assoc()['total'];
$stmt_count->close();
$total_pages = $total_records > 0 ? ceil($total_records / RECORDS_PER_PAGE) : 1;

// Obtener registros
$sql_data = "SELECT id, nombre, rut, email, telefono, activo FROM clientes WHERE empresa_id = ?";
$params_data = [$empresa_id];
$types_data = "i";
if (!empty($termino_busqueda)) {
    $sql_data .= " AND (nombre LIKE ? OR rut LIKE ? OR email LIKE ?)";
    array_push($params_data, $param_busqueda, $param_busqueda, $param_busqueda);
    $types_data .= "sss";
}
$sql_data .= " ORDER BY nombre ASC LIMIT ? OFFSET ?";
array_push($params_data, RECORDS_PER_PAGE, $offset);
$types_data .= "ii";
$stmt_data = $conn->prepare($sql_data);
$stmt_data->bind_param($types_data, ...$params_data);
$stmt_data->execute();
$clientes = $stmt_data->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_data->close();
?>

<div class="header-flex">
    <h1>Listado de Clientes</h1>
    <a href="<?= BASE_URL ?>clientes/crear" class="btn btn-primary">Crear Nuevo Cliente</a>
</div>

<div class="card search-bar">
    <form action="<?= BASE_URL ?>clientes" method="GET">
        <input type="text" name="q" placeholder="Buscar por nombre, RUT o email..." value="<?= sanitizar_html($termino_busqueda) ?>">
        <button type="submit" class="btn">Buscar</button>
    </form>
</div>

<div class="card">
    <table class="table">
        <thead>
            <tr>
                <th>Nombre</th>
                <th>RUT</th>
                <th>Email</th>
                <th>Teléfono</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($clientes)): ?>
                <tr><td colspan="6" style="text-align: center; padding: 20px;">No se encontraron clientes.</td></tr>
            <?php else: ?>
                <?php foreach ($clientes as $cliente): ?>
                    <tr>
                        <td><?= sanitizar_html($cliente['nombre']) ?></td>
                        <td><?= sanitizar_html($cliente['rut']) ?></td>
                        <td><?= sanitizar_html($cliente['email']) ?></td>
                        <td><?= sanitizar_html($cliente['telefono']) ?></td>
                        <td>
                            <span class="badge <?= $cliente['activo'] ? 'estado-activo' : 'estado-inactivo' ?>">
                                <?= $cliente['activo'] ? 'Activo' : 'Inactivo' ?>
                            </span>
                        </td>
                        <td>
                            <a href="<?= BASE_URL ?>clientes/<?= $cliente['id'] ?>/editar" class="btn btn-secondary btn-sm">Editar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<div class="pagination">
    <div class="pagination-info">
        Página <?= $page ?> de <?= $total_pages ?> (Total: <?= $total_records ?> clientes)
    </div>
    <div class="pagination-links">
        <?php if ($page > 1): ?>
            <a href="?page=<?= $page - 1 ?>&q=<?= urlencode($termino_busqueda) ?>" class="btn btn-secondary">Anterior</a>
        <?php endif; ?>
        <?php if ($page < $total_pages): ?>
            <a href="?page=<?= $page + 1 ?>&q=<?= urlencode($termino_busqueda) ?>" class="btn btn-secondary">Siguiente</a>
        <?php endif; ?>
    </div>
</div>

<?php
require_once ROOT_PATH . '/templates/footer.php';
?>
