<?php
// Módulo: Editar Cliente
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

$usuario = obtener_usuario_actual($conn);
$empresa = obtener_empresa_actual($conn);
$error = '';

// Obtener ID del cliente de la URL
$url_parts = explode('/', trim($_GET['url'] ?? '', '/'));
$cliente_id = isset($url_parts[1]) ? intval($url_parts[1]) : 0;

if (!$cliente_id) {
    header('Location: ' . BASE_URL . 'clientes');
    exit;
}

// Buscar cliente en la BD
$sql_find = "SELECT * FROM clientes WHERE id = ? AND empresa_id = ?";
$stmt_find = $conn->prepare($sql_find);
$stmt_find->bind_param("ii", $cliente_id, $empresa['id']);
$stmt_find->execute();
$result_find = $stmt_find->get_result();
$cliente = $result_find->fetch_assoc();
$stmt_find->close();

if (!$cliente) {
    // Si el cliente no existe, redirigir
    header('Location: ' . BASE_URL . 'clientes');
    exit;
}

// Procesar formulario de actualización
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = sanitizar_html($_POST['nombre'] ?? '');
    $rut = sanitizar_html($_POST['rut'] ?? '');
    $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
    $telefono = sanitizar_html($_POST['telefono'] ?? '');
    $activo = isset($_POST['activo']) ? 1 : 0;
    
    if ($nombre && $rut && $email) {
        $sql = "UPDATE clientes SET nombre = ?, rut = ?, email = ?, telefono = ?, activo = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssii", $nombre, $rut, $email, $telefono, $activo, $cliente_id);

        if ($stmt->execute()) {
            header('Location: ' . BASE_URL . 'clientes');
            exit;
        } else {
            $error = "Error al actualizar el cliente.";
        }
        $stmt->close();
    } else {
        $error = "Por favor, complete todos los campos obligatorios (*).";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Cliente - Portal Reclamos SSR</title>
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/estilos.css">
</head>
<body>
    <nav class="navbar">
         <div class="navbar-content">
            <a href="<?= BASE_URL ?>dashboard" class="navbar-brand">Portal Reclamos SSR</a>
             <div class="navbar-menu">
                <a href="<?= BASE_URL ?>casos">Casos</a>
                <a href="<?= BASE_URL ?>clientes" class="active">Clientes</a>
            </div>
        </div>
    </nav>
    
    <div class="container">
        <div class="header">
            <h1>Editar Cliente</h1>
            <a href="<?= BASE_URL ?>clientes" class="btn btn-secondary">← Volver</a>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <div class="card">
            <form method="POST">
                <div class="form-group">
                    <label>Nombre Completo *</label>
                    <input type="text" name="nombre" class="form-control" value="<?= sanitizar_html($cliente['nombre']) ?>" required>
                </div>
                <div class="form-group">
                    <label>RUT *</label>
                    <input type="text" name="rut" class="form-control" value="<?= sanitizar_html($cliente['rut']) ?>" required>
                </div>
                <div class="form-group">
                    <label>Email *</label>
                    <input type="email" name="email" class="form-control" value="<?= sanitizar_html($cliente['email']) ?>" required>
                </div>
                <div class="form-group">
                    <label>Teléfono</label>
                    <input type="text" name="telefono" class="form-control" value="<?= sanitizar_html($cliente['telefono']) ?>">
                </div>
                 <div class="form-group">
                    <label style="display: flex; align-items: center; gap: 10px;">
                        <input type="checkbox" name="activo" <?= $cliente['activo'] ? 'checked' : '' ?>>
                        <span>Cliente Activo</span>
                    </label>
                </div>
                <div style="display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                    <a href="<?= BASE_URL ?>clientes" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
